% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_subsamples.R
\name{generate_subsamples}
\alias{generate_subsamples}
\title{Generate subsamples of a data frame with a number of sites between a minimum
and maximum value.}
\usage{
generate_subsamples(
  data,
  min_sites = 1,
  max_sites = nrow(data),
  step = 1,
  reps = 100,
  summary = TRUE,
  seed = sample(0:9999, 1)
)
}
\arguments{
\item{data}{A data frame of count data,
with sites as rows and species as columns.}

\item{min_sites}{The minimum number of sites to include in a subsample.}

\item{max_sites}{The maximum number of sites to include in a subsample.
Defaults to the number of sites in the original data set.}

\item{step}{The number of sites to increase by at each iteration.}

\item{reps}{The number of subsamples with a given number of sites to create.}

\item{summary}{A logical indicating whether to calculate summary indices
using \code{\link{calc_diversity_indices}}. Defaults to TRUE.}

\item{seed}{A random seed to use for reproducibility.}
}
\value{
A list of lists of data frames, if \code{summary = FALSE}, each data
frame is a subsample of the original data set. If \code{summary =
      TRUE}, each data frame is a subsample of the original data set with
diversity indices calculated using
\code{\link{calc_diversity_indices}}.
}
\description{
Generate subsamples of a data frame with a number of sites between a minimum
and maximum value.
}
\examples{
ss <- generate_subsamples(BCI,
                          min_sites = 1,
                          max_sites = 5,
                          step = 1,
                          reps = 2)
}
