% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sample_stats.R
\name{get_sample_stats}
\alias{get_sample_stats}
\title{Calculate biodiversity measures and summary statistics for a data set
using repeated sampling}
\usage{
get_sample_stats(data, sites_col = 1, reps = 100, indices = "all")
}
\arguments{
\item{data}{A data frame of count data,
with sites as rows and species as columns.}

\item{sites_col}{The column number of column containing site IDs.}

\item{reps}{The number of resamples to create.}

\item{indices}{A vector of indices to calculate. Use "all" to calculate
all indices. Available indices are: abundance,
richness, shannon, simpson, chao1, and chao_diff.}
}
\value{
A list of two data frames. The first data frame contains site
specific data with sites as rows and summary statistics as columns.
The second contains an overall summary of the data.
}
\description{
Calculate biodiversity measures and summary statistics for a data set
using repeated sampling
}
\examples{
stats <- get_sample_stats(BCI, reps = 5)
}
