% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.r
\name{calcWhalley}
\alias{calcWhalley}
\title{Calculate Whalley revised BMWP indices for invertebrate samples}
\usage{
calcWhalley(df, type = "num")
}
\arguments{
\item{df}{A dataframe containing list of taxa in first column, followed by
columns of abundances with sample names in header row.}

\item{type}{Indicates format of data. Options are "num" for numeric data,
"log" for integer log abundance categories (1-5) or "alpha" for alphabetic
abundance categories (A-E). Default value is "num".}
}
\value{
A data frame consisting of columns of index values with samples
in rows.
}
\description{
Calculates Whalley revised BMWP, ASPT and N-taxa indices
for invertebrate samples.
}
\examples{

# calculate the Whalley revised BMWP indices for the Green Burn dataset
# data are numeric log abundance categories, so type is "log"

calcWhalley(greenburn, "log")
}

