% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcindex.r
\name{calcindex}
\alias{calcindex}
\title{Calculate biotic indices for invertebrate samples}
\usage{
calcindex(df, index = "BMWP", type = "num")
}
\arguments{
\item{df}{A dataframe containing list of taxon names and their abundances
in samples, along with sample identifiers.  Default format is for taxon
names to be in the first column and sample abundances in subsequent
columns with identifers as column headers. See built-in \code{\link{almond}}
 dataset for an example. If data are in the transposed format i.e taxa as
 columns and samples as rows, the \code{\link{transposedata}} function can
 be used prior to calculation.}

\item{index}{A choice of index to be calculated. Defaults to \code{"BMWP"}.
Options are: \code{"BMWP"}, \code{"Whalley"}, \code{"Riffle"}, \code{"Pool"},
\code{"RiffPool"}, \code{"LIFE"}, \code{"PSI"}, \code{"WHPT"},
\code{"WHPT_AB"} and \code{"AWIC"}.}

\item{type}{Indicates type of data being processed. Options are "num" for
numeric data, "log" for integer log abundance categories (1-5) or "alpha"
for alphabetic abundance categories (A-E). Default value is "num".}
}
\value{
A data frame consisting of columns of index values with samples in
rows. The number of columns returned depends on the index selected.
}
\description{
Calculates a range of freshwater invertebrate biotic indices
 in use in the UK (based on family level identification). Currently
 calculates BMWP (N-taxa and ASPT), Whalley revised BMWP, Whalley habitat
  specific BWMP (riffle, pool and riffle/pool), LIFE, PSI, WHPT
  (presence-absence and abundance-weighted) and AWIC.  For details of these
   indices see the vignette.
}
\examples{
# use the built-in River Almond dataset, numeric abundances

# calculate the BMWP index for this dataset
# 'index' and 'type' do not have to specified as defaults are used
# ("BMWP" and "num")

calcindex(almond)

# calculate the PSI index for this dataset
# type does not have to specified as default is used ("num")

calcindex(almond, "PSI")

# calculate the WHPT abundance-weighted index for this dataset

calcindex(almond, "WHPT_AB")

# example of processing data in alphabetic log abundance categories
# using the 'type' argument

# 'braidburn' dataset contains alphabetic log category data
# see ?braidburn for details

# calculate the Whalley revised BMWP index (including N-taxa and ASPT)

calcindex(braidburn, "Whalley", "alpha")

# example of processing data in numeric log abundance categories
# using the 'type' argument

# 'greenburn' dataset contains numeric log category data
# see ?greenburn for details

# calculate the LIFE index for this dataset

calcindex(greenburn, "LIFE", "log")

}

