% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipd.run.R
\name{ipd.run}
\alias{ipd.run}
\title{Run the model using the ipd object}
\usage{
ipd.run(
  ipd,
  pars.save = NULL,
  inits = NULL,
  n.chains = 3,
  n.adapt = 1000,
  n.burnin = 1000,
  n.iter = 10000
)
}
\arguments{
\item{ipd}{ipd object created from ipd.model type function}

\item{pars.save}{parameters to save. For instance, "beta" - coefficients for main effects; "gamma" - coefficients for effect modifiers; "delta" - average treatment effect}

\item{inits}{initial values specified for the parameters to save}

\item{n.chains}{number of MCMC chains to sample}

\item{n.adapt}{number of iterations for adaptation (Note that the samples from adaptation phase is non-Markovian and do not constitute a Markov chain)}

\item{n.burnin}{number of iterations for burn-in}

\item{n.iter}{number of iterations to run after the adaptation}
}
\value{
MCMC samples stored using JAGS. The returned samples have the form of mcmc.list and coda functions can be directly applied.
}
\description{
This is the core function that runs the model in our program. Before running this function, we need to specify data, prior, JAGS code, etc. using ipd.model type function.
}
\examples{
ds <- generate_ipdma_example(type = "continuous")
ipd <- with(ds, ipdma.model.onestage(y = y, study = studyid, treat = treat, X = cbind(z1, z2), 
response = "normal", shrinkage = "none"))
\donttest{
samples <- ipd.run(ipd, n.chains = 3, n.burnin = 500, n.iter = 5000)
}
}
