% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tempbetagrid.R
\name{tempbetagrid}
\alias{tempbetagrid}
\title{tempbetagrid: Calculates Temporal Beta Grid Using Species' Occurrences}
\usage{
tempbetagrid(oc1, oc2, index = "sorensen", phylotree, phylobeta = F)
}
\arguments{
\item{oc1}{Community data matrix (species occurrence on each grid cell).}

\item{oc2}{Second community data matrix (species occurrence on each grid cell) for another time period.}

\item{index}{Calculate "sorensen" or "jaccard". Default is "sorensen".}

\item{phylotree}{Optional phylogenetic tree ("phylo" class). It can also be a functional dendrogram.}

\item{phylobeta}{Optional boolean indicating whether or not to calculate phylogenetic beta diversity (see "phylo.beta.pair" function in "betapart" package) instead of the usual beta diversity (see "beta.pair" function in "betapart" package). Default is F.}
}
\value{
A data frame with values of turnover, nestedness, beta diversity, and turnover/beta for each site or grid cell.
}
\description{
Uses two occurrence matrices (from different time periods) to calculate temporal beta diversity for each site or grid cell.
}
\examples{
# https://rfunctions.blogspot.com/2016/10/calculating-temporal-beta-diversity-on.html
}
