% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bkmr_main_functions.R
\name{print.bkmrfit}
\alias{print.bkmrfit}
\title{Print basic summary of BKMR model fit}
\usage{
\method{print}{bkmrfit}(x, digits = 5, ...)
}
\arguments{
\item{x}{an object of class "bkmrfit"}

\item{digits}{the number of digits to show when printing}

\item{...}{further arguments passed to or from other methods.}
}
\value{
No return value, prints basic summary of fit to console
}
\description{
\code{print} method for class "bkmrfit"
}
\examples{
## First generate dataset
set.seed(111)
dat <- SimData(n = 50, M = 4)
y <- dat$y
Z <- dat$Z
X <- dat$X

## Fit model with component-wise variable selection
## Using only 100 iterations to make example run quickly
## Typically should use a large number of iterations for inference
set.seed(111)
fitkm <- kmbayes(y = y, Z = Z, X = X, iter = 100, verbose = FALSE, varsel = TRUE)
fitkm
}
