% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QmatrixToBlatentSyntax.R
\name{QmatrixToBlatentSyntax}
\alias{QmatrixToBlatentSyntax}
\title{Convert a rectangular Q-matrix into blatent model syntax}
\usage{
QmatrixToBlatentSyntax(
  Qmatrix,
  observedVariables = "rownames",
  latentVariables = "colnames",
  lvDist = "joint"
)
}
\arguments{
\item{Qmatrix}{A data frame or matrix containing a Q-matrix.}

\item{observedVariables}{If \code{Qmatrix} is data.frame, the variable in the data frame that has the names of the observed variables. Defaults to \code{"rownames"},
which uses \code{rownames(Qmatrix)} and works for data.frame or matrix types of \code{Qmatrix}.}

\item{latentVariables}{A vector of the variable or column names of the latent variables. Defaults to \code{"colnames"}, which uses \code{colnames(Qmatrix)}
and works for data.frame or matrix types of \code{Qmatrix}.}

\item{lvDist}{A character that indicates the type of latent variable distribution to be used. \code{"joint"} for joint distributions (multivariate Bernoulli) or
\code{"univariate"} for univariate Bernoulli using BayesNets parameterization. The latter also builds blatent syntax for the BayesNets model terms.}
}
\value{
A character vector containing blatent model syntax.
}
\description{
Converts a rectangular Q-matrix into blatent model syntax. Q-matrix must have observed variables listed across columns and latent variables listed across rows.
}
\examples{


# Example 1: Joint distribution using data.frame
# empty data.frame

exampleQmatrixDF = data.frame(matrix(data = 0, nrow = 10, ncol = 3))

# name columns of Qmatrix

names(exampleQmatrixDF) = c("observedVariableName", "Attribute1", "Attribute2")

# names of observed variables

exampleQmatrixDF[1:10, "observedVariableName"] = paste0("Item",1:10)

# Entries for Qmatrix

exampleQmatrixDF[1:5,"Attribute1"] = 1
exampleQmatrixDF[3:10,"Attribute2"] = 1

# produce blatentSyntax using QmatrixToBlatentSyntax() function

blatentSyntaxJoint = QmatrixToBlatentSyntax(
   Qmatrix = exampleQmatrixDF,
   observedVariables = "observedVariableName",
   latentVariables = c("Attribute1", "Attribute2"),
   lvDist = "joint"
 )
cat(blatentSyntaxJoint)

# Example 2: Univariate distributions using matrix
# empty data.frame

exampleQmatrixM = matrix(data = 0, nrow = 10, ncol = 2)

# name columns of Qmatrix as latent variable names

colnames(exampleQmatrixM) = c("Attribute1", "Attribute2")

# name rows of Qmatrix as observed variable names

rownames(exampleQmatrixM) = paste0("Item",1:10)

# Entries for Qmatrix

exampleQmatrixM[1:5,"Attribute1"] = 1
exampleQmatrixM[3:10,"Attribute2"] = 1

# produce blatentSyntax using QmatrixToBlatentSyntax() function
#  (with default options for observedVariables and latentVariables)

blatentSyntaxM = QmatrixToBlatentSyntax(Qmatrix = exampleQmatrixM,  lvDist = "univariate")
cat(blatentSyntaxM)


}
