% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_tables.R
\name{data_as_table}
\alias{data_as_table}
\title{Convert a list of data entries as returned by BLS API to a table}
\usage{
data_as_table(data, parse_values = TRUE)
}
\arguments{
\item{data}{a list of individual datum entries as returned by the API}

\item{parse_values}{optional boolean. If set to \code{TRUE} (default) it will
attempt to parse the contents of \code{value} and cast numeric strings as numeric
values. If set to \code{FALSE} it will retain \code{value} as a column of strings.}
}
\value{
tibble flattening \code{data} into rows for entries and columns for fields
}
\description{
Convert a list of data entries as returned by BLS API to a table
}
\details{
currently \code{data_as_table} is very similar to \code{\link[dplyr:bind_rows]{dplyr::bind_rows()}}
}
\examples{
\dontrun{
series <- get_series('LNS14000001')
table <- data_as_table(series$data)
}
}
\seealso{
Other blsR-utils: 
\code{\link{bls-api-key}},
\code{\link{data_as_tidy_table}()},
\code{\link{merge_tables}()},
\code{\link{merge_tidy_tables}()},
\code{\link{reduce_spanned_responses}()},
\code{\link{span_request_queries}()},
\code{\link{span_series_request}()},
\code{\link{tidy_periods}()},
\code{\link{tidy_table_as_zoo}()}
}
\concept{blsR-utils}
