% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{query_series}
\alias{query_series}
\title{Create a query for a single time series}
\usage{
query_series(series_id, start_year = NULL, end_year = NULL)
}
\arguments{
\item{series_id}{Character scalar BLS series ID}

\item{start_year, end_year}{numeric 4-digit years. While optional, they are
strongly recommended. If one is provided, the other is mandatory. \code{end_year}
must be greater than \code{start_year}}
}
\value{
list of query parameters
}
\description{
Create a query for a single time series
}
\examples{

unemployment_rate_query <- query_series('LNS14000000')
unemployment_rate_query <- query_series('LNS14000000', 2005, 2010)

}
\seealso{
Other blsR-queries: 
\code{\link{query_all_surveys}()},
\code{\link{query_latest_observation}()},
\code{\link{query_n_series}()},
\code{\link{query_popular_series}()},
\code{\link{query_survey_info}()},
\code{\link{span_request_queries}()}
}
\concept{blsR-queries}
