% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_month_data.R
\name{import_month_data}
\alias{import_month_data}
\title{Import monthly data from bluebike system data}
\usage{
import_month_data(year, month)
}
\arguments{
\item{year}{numeric value of year}

\item{month}{numeric value of month}
}
\value{
A spec_tbl_df object
}
\description{
This function takes in numeric year/month values and imports data for the specified time
}
\examples{
\donttest{
# Pull Jan., 2015 data from web
library(dplyr)
jan_2015 <- import_month_data(2015, 1)

# Pull first quarter of 2015 data from web
spring2015 <- c(1, 2, 3)
quarter_1_2015 <- lapply(spring2015, import_month_data, year = 2015)
quarter_1_2015 <- bind_rows(quarter_1_2015)
}
}
