// Generated by rstantools.  Do not edit by hand.

/*
    bmgarch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    bmgarch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with bmgarch.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_forecastBEKK_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'forecastBEKK', line 53, column 0 to column 16)",
                                                      " (in 'forecastBEKK', line 58, column 0 to column 41)",
                                                      " (in 'forecastBEKK', line 59, column 0 to column 43)",
                                                      " (in 'forecastBEKK', line 63, column 2 to column 23)",
                                                      " (in 'forecastBEKK', line 64, column 2 to column 19)",
                                                      " (in 'forecastBEKK', line 67, column 2 to column 22)",
                                                      " (in 'forecastBEKK', line 70, column 2 to column 23)",
                                                      " (in 'forecastBEKK', line 72, column 2 to column 22)",
                                                      " (in 'forecastBEKK', line 73, column 2 to column 28)",
                                                      " (in 'forecastBEKK', line 74, column 2 to column 30)",
                                                      " (in 'forecastBEKK', line 75, column 2 to column 25)",
                                                      " (in 'forecastBEKK', line 76, column 2 to column 28)",
                                                      " (in 'forecastBEKK', line 77, column 2 to column 28)",
                                                      " (in 'forecastBEKK', line 78, column 2 to column 32)",
                                                      " (in 'forecastBEKK', line 82, column 2 to column 43)",
                                                      " (in 'forecastBEKK', line 83, column 2 to column 41)",
                                                      " (in 'forecastBEKK', line 85, column 2 to column 45)",
                                                      " (in 'forecastBEKK', line 86, column 2 to column 46)",
                                                      " (in 'forecastBEKK', line 87, column 2 to column 43)",
                                                      " (in 'forecastBEKK', line 88, column 2 to column 44)",
                                                      " (in 'forecastBEKK', line 89, column 2 to column 45)",
                                                      " (in 'forecastBEKK', line 90, column 2 to column 42)",
                                                      " (in 'forecastBEKK', line 91, column 2 to column 40)",
                                                      " (in 'forecastBEKK', line 92, column 2 to column 66)",
                                                      " (in 'forecastBEKK', line 95, column 2 to column 52)",
                                                      " (in 'forecastBEKK', line 98, column 2 to column 26)",
                                                      " (in 'forecastBEKK', line 99, column 2 to column 26)",
                                                      " (in 'forecastBEKK', line 102, column 2 to column 63)",
                                                      " (in 'forecastBEKK', line 103, column 2 to column 62)",
                                                      " (in 'forecastBEKK', line 104, column 2 to column 62)",
                                                      " (in 'forecastBEKK', line 105, column 2 to column 62)",
                                                      " (in 'forecastBEKK', line 107, column 2 to column 63)",
                                                      " (in 'forecastBEKK', line 110, column 2 to column 55)",
                                                      " (in 'forecastBEKK', line 111, column 2 to column 54)",
                                                      " (in 'forecastBEKK', line 112, column 2 to column 54)",
                                                      " (in 'forecastBEKK', line 114, column 2 to column 60)",
                                                      " (in 'forecastBEKK', line 115, column 2 to column 59)",
                                                      " (in 'forecastBEKK', line 120, column 4 to column 49)",
                                                      " (in 'forecastBEKK', line 121, column 4 to column 49)",
                                                      " (in 'forecastBEKK', line 126, column 6 to column 83)",
                                                      " (in 'forecastBEKK', line 125, column 35 to line 127, column 5)",
                                                      " (in 'forecastBEKK', line 125, column 11 to line 127, column 5)",
                                                      " (in 'forecastBEKK', line 124, column 6 to column 23)",
                                                      " (in 'forecastBEKK', line 123, column 28 to line 125, column 5)",
                                                      " (in 'forecastBEKK', line 123, column 4 to line 127, column 5)",
                                                      " (in 'forecastBEKK', line 129, column 6 to column 78)",
                                                      " (in 'forecastBEKK', line 130, column 6 to column 54)",
                                                      " (in 'forecastBEKK', line 128, column 31 to line 131, column 5)",
                                                      " (in 'forecastBEKK', line 128, column 4 to line 131, column 5)",
                                                      " (in 'forecastBEKK', line 133, column 6 to column 53)",
                                                      " (in 'forecastBEKK', line 132, column 31 to line 134, column 5)",
                                                      " (in 'forecastBEKK', line 132, column 4 to line 134, column 5)",
                                                      " (in 'forecastBEKK', line 138, column 6 to line 139, column 22)",
                                                      " (in 'forecastBEKK', line 137, column 31 to line 140, column 5)",
                                                      " (in 'forecastBEKK', line 137, column 11 to line 140, column 5)",
                                                      " (in 'forecastBEKK', line 136, column 6 to column 74)",
                                                      " (in 'forecastBEKK', line 135, column 25 to line 137, column 5)",
                                                      " (in 'forecastBEKK', line 135, column 4 to line 140, column 5)",
                                                      " (in 'forecastBEKK', line 141, column 4 to column 32)",
                                                      " (in 'forecastBEKK', line 147, column 2 to column 58)",
                                                      " (in 'forecastBEKK', line 146, column 33 to line 148, column 2)",
                                                      " (in 'forecastBEKK', line 146, column 8 to line 148, column 2)",
                                                      " (in 'forecastBEKK', line 145, column 2 to column 51)",
                                                      " (in 'forecastBEKK', line 144, column 25 to line 146, column 2)",
                                                      " (in 'forecastBEKK', line 144, column 0 to line 148, column 2)",
                                                      " (in 'forecastBEKK', line 118, column 52 to line 164, column 3)",
                                                      " (in 'forecastBEKK', line 118, column 2 to line 164, column 3)",
                                                      " (in 'forecastBEKK', line 165, column 2 to column 62)",
                                                      " (in 'forecastBEKK', line 166, column 2 to column 58)",
                                                      " (in 'forecastBEKK', line 167, column 2 to column 58)",
                                                      " (in 'forecastBEKK', line 168, column 2 to column 60)",
                                                      " (in 'forecastBEKK', line 177, column 6 to column 96)",
                                                      " (in 'forecastBEKK', line 176, column 22 to line 178, column 5)",
                                                      " (in 'forecastBEKK', line 176, column 4 to line 178, column 5)",
                                                      " (in 'forecastBEKK', line 175, column 33 to line 179, column 3)",
                                                      " (in 'forecastBEKK', line 175, column 9 to line 179, column 3)",
                                                      " (in 'forecastBEKK', line 173, column 6 to column 89)",
                                                      " (in 'forecastBEKK', line 172, column 22 to line 174, column 5)",
                                                      " (in 'forecastBEKK', line 172, column 4 to line 174, column 5)",
                                                      " (in 'forecastBEKK', line 171, column 26 to line 175, column 3)",
                                                      " (in 'forecastBEKK', line 171, column 2 to line 179, column 3)",
                                                      " (in 'forecastBEKK', line 170, column 22 to line 180, column 2)",
                                                      " (in 'forecastBEKK', line 170, column 0 to line 180, column 2)",
                                                      " (in 'forecastBEKK', line 14, column 0 to column 15)",
                                                      " (in 'forecastBEKK', line 15, column 0 to column 16)",
                                                      " (in 'forecastBEKK', line 16, column 0 to column 15)",
                                                      " (in 'forecastBEKK', line 17, column 0 to column 15)",
                                                      " (in 'forecastBEKK', line 18, column 6 to column 7)",
                                                      " (in 'forecastBEKK', line 18, column 16 to column 18)",
                                                      " (in 'forecastBEKK', line 18, column 0 to column 24)",
                                                      " (in 'forecastBEKK', line 19, column 6 to column 7)",
                                                      " (in 'forecastBEKK', line 19, column 16 to column 18)",
                                                      " (in 'forecastBEKK', line 19, column 0 to column 23)",
                                                      " (in 'forecastBEKK', line 20, column 0 to column 35)",
                                                      " (in 'forecastBEKK', line 21, column 0 to column 36)",
                                                      " (in 'forecastBEKK', line 22, column 0 to column 19)",
                                                      " (in 'forecastBEKK', line 23, column 6 to column 11)",
                                                      " (in 'forecastBEKK', line 23, column 20 to column 22)",
                                                      " (in 'forecastBEKK', line 23, column 0 to column 29)",
                                                      " (in 'forecastBEKK', line 24, column 6 to column 11)",
                                                      " (in 'forecastBEKK', line 24, column 20 to column 22)",
                                                      " (in 'forecastBEKK', line 24, column 0 to column 35)",
                                                      " (in 'forecastBEKK', line 25, column 0 to column 42)",
                                                      " (in 'forecastBEKK', line 28, column 9 to column 25)",
                                                      " (in 'forecastBEKK', line 28, column 27 to column 29)",
                                                      " (in 'forecastBEKK', line 28, column 2 to column 36)",
                                                      " (in 'forecastBEKK', line 31, column 6 to column 7)",
                                                      " (in 'forecastBEKK', line 31, column 16 to column 18)",
                                                      " (in 'forecastBEKK', line 31, column 20 to column 22)",
                                                      " (in 'forecastBEKK', line 31, column 0 to column 29)",
                                                      " (in 'forecastBEKK', line 32, column 0 to column 29)",
                                                      " (in 'forecastBEKK', line 33, column 0 to column 19)",
                                                      " (in 'forecastBEKK', line 36, column 2 to column 33)",
                                                      " (in 'forecastBEKK', line 38, column 2 to column 33)",
                                                      " (in 'forecastBEKK', line 40, column 4 to column 30)",
                                                      " (in 'forecastBEKK', line 39, column 2 to line 40, column 30)",
                                                      " (in 'forecastBEKK', line 35, column 15 to line 41, column 2)",
                                                      " (in 'forecastBEKK', line 35, column 0 to line 41, column 2)",
                                                      " (in 'forecastBEKK', line 44, column 4 to column 38)",
                                                      " (in 'forecastBEKK', line 43, column 24 to line 45, column 3)",
                                                      " (in 'forecastBEKK', line 43, column 2 to line 45, column 3)",
                                                      " (in 'forecastBEKK', line 47, column 4 to column 34)",
                                                      " (in 'forecastBEKK', line 46, column 20 to line 48, column 3)",
                                                      " (in 'forecastBEKK', line 46, column 2 to line 48, column 3)",
                                                      " (in 'forecastBEKK', line 53, column 7 to column 9)",
                                                      " (in 'forecastBEKK', line 58, column 30 to column 32)",
                                                      " (in 'forecastBEKK', line 58, column 33 to column 35)",
                                                      " (in 'forecastBEKK', line 59, column 30 to column 32)",
                                                      " (in 'forecastBEKK', line 59, column 33 to column 35)",
                                                      " (in 'forecastBEKK', line 63, column 13 to column 15)",
                                                      " (in 'forecastBEKK', line 64, column 9 to column 11)",
                                                      " (in 'forecastBEKK', line 67, column 14 to column 16)",
                                                      " (in 'forecastBEKK', line 72, column 13 to column 15)",
                                                      " (in 'forecastBEKK', line 73, column 8 to column 9)",
                                                      " (in 'forecastBEKK', line 73, column 22 to column 24)",
                                                      " (in 'forecastBEKK', line 74, column 8 to column 11)",
                                                      " (in 'forecastBEKK', line 74, column 20 to column 22)",
                                                      " (in 'forecastBEKK', line 74, column 23 to column 25)",
                                                      " (in 'forecastBEKK', line 75, column 8 to column 9)",
                                                      " (in 'forecastBEKK', line 75, column 18 to column 20)",
                                                      " (in 'forecastBEKK', line 76, column 8 to column 9)",
                                                      " (in 'forecastBEKK', line 76, column 18 to column 20)",
                                                      " (in 'forecastBEKK', line 76, column 22 to column 24)",
                                                      " (in 'forecastBEKK', line 77, column 8 to column 9)",
                                                      " (in 'forecastBEKK', line 77, column 18 to column 20)",
                                                      " (in 'forecastBEKK', line 77, column 22 to column 24)",
                                                      " (in 'forecastBEKK', line 78, column 8 to column 9)",
                                                      " (in 'forecastBEKK', line 78, column 23 to column 25)",
                                                      " (in 'forecastBEKK', line 82, column 8 to column 24)",
                                                      " (in 'forecastBEKK', line 82, column 33 to column 35)",
                                                      " (in 'forecastBEKK', line 83, column 8 to column 13)",
                                                      " (in 'forecastBEKK', line 83, column 22 to column 24)",
                                                      " (in 'forecastBEKK', line 85, column 8 to column 24)",
                                                      " (in 'forecastBEKK', line 85, column 37 to column 39)",
                                                      " (in 'forecastBEKK', line 86, column 8 to column 24)",
                                                      " (in 'forecastBEKK', line 86, column 38 to column 40)",
                                                      " (in 'forecastBEKK', line 87, column 8 to column 13)",
                                                      " (in 'forecastBEKK', line 87, column 26 to column 28)",
                                                      " (in 'forecastBEKK', line 88, column 8 to column 13)",
                                                      " (in 'forecastBEKK', line 88, column 27 to column 29)",
                                                      " (in 'forecastBEKK', line 89, column 8 to column 24)",
                                                      " (in 'forecastBEKK', line 89, column 33 to column 35)",
                                                      " (in 'forecastBEKK', line 89, column 36 to column 38)",
                                                      " (in 'forecastBEKK', line 90, column 8 to column 24)",
                                                      " (in 'forecastBEKK', line 90, column 33 to column 35)",
                                                      " (in 'forecastBEKK', line 91, column 8 to column 13)",
                                                      " (in 'forecastBEKK', line 91, column 22 to column 24)",
                                                      " (in 'forecastBEKK', line 92, column 9 to column 13)",
                                                      " (in 'forecastBEKK', line 92, column 15 to column 17)",
                                                      " (in 'forecastBEKK', line 95, column 8 to column 37)",
                                                      " (in 'forecastBEKK', line 98, column 9 to column 11)",
                                                      " (in 'forecastBEKK', line 98, column 13 to column 15)",
                                                      " (in 'forecastBEKK', line 99, column 9 to column 11)",
                                                      " (in 'forecastBEKK', line 99, column 13 to column 15)",
                                                      " (in 'forecastBEKK', line 4, column 4 to column 21)",
                                                      " (in 'forecastBEKK', line 5, column 11 to column 13)",
                                                      " (in 'forecastBEKK', line 5, column 14 to column 16)",
                                                      " (in 'forecastBEKK', line 5, column 4 to column 20)",
                                                      " (in 'forecastBEKK', line 6, column 11 to column 13)",
                                                      " (in 'forecastBEKK', line 6, column 14 to column 16)",
                                                      " (in 'forecastBEKK', line 6, column 4 to column 20)",
                                                      " (in 'forecastBEKK', line 7, column 4 to column 46)",
                                                      " (in 'forecastBEKK', line 8, column 4 to column 15)",
                                                      " (in 'forecastBEKK', line 9, column 4 to column 13)",
                                                      " (in 'forecastBEKK', line 3, column 24 to line 10, column 1)"};
template <typename T0__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>>, -1, -1>
cov2cor(const T0__& C_arg__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>>;
  const auto& C = to_ref(C_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    int dm;
    dm = std::numeric_limits<int>::min();
    
    current_statement__ = 175;
    dm = rows(C);
    current_statement__ = 176;
    validate_non_negative_index("s", "dm", dm);
    current_statement__ = 177;
    validate_non_negative_index("s", "dm", dm);
    Eigen::Matrix<local_scalar_t__, -1, -1> s;
    s = Eigen::Matrix<local_scalar_t__, -1, -1>(dm, dm);
    stan::math::fill(s, DUMMY_VAR__);
    
    current_statement__ = 179;
    validate_non_negative_index("R", "dm", dm);
    current_statement__ = 180;
    validate_non_negative_index("R", "dm", dm);
    Eigen::Matrix<local_scalar_t__, -1, -1> R;
    R = Eigen::Matrix<local_scalar_t__, -1, -1>(dm, dm);
    stan::math::fill(R, DUMMY_VAR__);
    
    current_statement__ = 182;
    assign(s, nil_index_list(),
      diag_matrix(elt_divide(1, stan::math::sqrt(diagonal(C)))),
      "assigning variable s");
    current_statement__ = 183;
    assign(R, nil_index_list(), multiply(multiply(s, C), s),
      "assigning variable R");
    current_statement__ = 184;
    return R;
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct cov2cor_functor__ {
template <typename T0__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>>, -1, -1>
operator()(const T0__& C, std::ostream* pstream__)  const 
{
return cov2cor(C, pstream__);
}
};
#include <stan_meta_header.hpp>
class model_forecastBEKK final : public model_base_crtp<model_forecastBEKK> {
private:
  int T;
  int nt;
  int Q;
  int P;
  std::vector<Eigen::Matrix<double, -1, 1>> rts;
  std::vector<Eigen::Matrix<double, -1, 1>> xC;
  int distribution;
  int meanstructure;
  int ahead;
  std::vector<Eigen::Matrix<double, -1, 1>> xC_p;
  std::vector<Eigen::Matrix<double, -1, 1>> future_rts;
  int compute_log_lik;
  Eigen::Matrix<double, -1, -1> xC_c;
  std::vector<Eigen::Matrix<double, -1, -1>> xC_m;
  int xC_marker;
  double cp;
  int rr_1dim__;
  int rts_p_1dim__;
  int H_p_1dim__;
  int R_p_1dim__;
  int rr_p_1dim__;
  int mu_p_1dim__;
  int beta_1dim__;
  int log_lik_1dim__;
 
public:
  ~model_forecastBEKK() { }
  
  inline std::string model_name() const final { return "model_forecastBEKK"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_forecastBEKK(stan::io::var_context& context__,
                     unsigned int random_seed__ = 0,
                     std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_forecastBEKK_namespace::model_forecastBEKK";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 84;
      context__.validate_dims("data initialization","T","int",
          context__.to_vec());
      T = std::numeric_limits<int>::min();
      
      current_statement__ = 84;
      T = context__.vals_i("T")[(1 - 1)];
      current_statement__ = 84;
      current_statement__ = 84;
      check_greater_or_equal(function__, "T", T, 2);
      current_statement__ = 85;
      context__.validate_dims("data initialization","nt","int",
          context__.to_vec());
      nt = std::numeric_limits<int>::min();
      
      current_statement__ = 85;
      nt = context__.vals_i("nt")[(1 - 1)];
      current_statement__ = 85;
      current_statement__ = 85;
      check_greater_or_equal(function__, "nt", nt, 2);
      current_statement__ = 86;
      context__.validate_dims("data initialization","Q","int",
          context__.to_vec());
      Q = std::numeric_limits<int>::min();
      
      current_statement__ = 86;
      Q = context__.vals_i("Q")[(1 - 1)];
      current_statement__ = 86;
      current_statement__ = 86;
      check_greater_or_equal(function__, "Q", Q, 1);
      current_statement__ = 87;
      context__.validate_dims("data initialization","P","int",
          context__.to_vec());
      P = std::numeric_limits<int>::min();
      
      current_statement__ = 87;
      P = context__.vals_i("P")[(1 - 1)];
      current_statement__ = 87;
      current_statement__ = 87;
      check_greater_or_equal(function__, "P", P, 1);
      current_statement__ = 88;
      validate_non_negative_index("rts", "T", T);
      current_statement__ = 89;
      validate_non_negative_index("rts", "nt", nt);
      current_statement__ = 90;
      context__.validate_dims("data initialization","rts","double",
          context__.to_vec(T, nt));
      rts = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(rts, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> rts_flat__;
        current_statement__ = 90;
        assign(rts_flat__, nil_index_list(), context__.vals_r("rts"),
          "assigning variable rts_flat__");
        current_statement__ = 90;
        pos__ = 1;
        current_statement__ = 90;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 90;
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            current_statement__ = 90;
            assign(rts,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              rts_flat__[(pos__ - 1)], "assigning variable rts");
            current_statement__ = 90;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 91;
      validate_non_negative_index("xC", "T", T);
      current_statement__ = 92;
      validate_non_negative_index("xC", "nt", nt);
      current_statement__ = 93;
      context__.validate_dims("data initialization","xC","double",
          context__.to_vec(T, nt));
      xC = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(xC, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> xC_flat__;
        current_statement__ = 93;
        assign(xC_flat__, nil_index_list(), context__.vals_r("xC"),
          "assigning variable xC_flat__");
        current_statement__ = 93;
        pos__ = 1;
        current_statement__ = 93;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 93;
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            current_statement__ = 93;
            assign(xC,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              xC_flat__[(pos__ - 1)], "assigning variable xC");
            current_statement__ = 93;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 94;
      context__.validate_dims("data initialization","distribution","int",
          context__.to_vec());
      distribution = std::numeric_limits<int>::min();
      
      current_statement__ = 94;
      distribution = context__.vals_i("distribution")[(1 - 1)];
      current_statement__ = 94;
      current_statement__ = 94;
      check_greater_or_equal(function__, "distribution", distribution, 0);
      current_statement__ = 94;
      current_statement__ = 94;
      check_less_or_equal(function__, "distribution", distribution, 1);
      current_statement__ = 95;
      context__.validate_dims("data initialization","meanstructure","int",
          context__.to_vec());
      meanstructure = std::numeric_limits<int>::min();
      
      current_statement__ = 95;
      meanstructure = context__.vals_i("meanstructure")[(1 - 1)];
      current_statement__ = 95;
      current_statement__ = 95;
      check_greater_or_equal(function__, "meanstructure", meanstructure, 0);
      current_statement__ = 95;
      current_statement__ = 95;
      check_less_or_equal(function__, "meanstructure", meanstructure, 2);
      current_statement__ = 96;
      context__.validate_dims("data initialization","ahead","int",
          context__.to_vec());
      ahead = std::numeric_limits<int>::min();
      
      current_statement__ = 96;
      ahead = context__.vals_i("ahead")[(1 - 1)];
      current_statement__ = 96;
      current_statement__ = 96;
      check_greater_or_equal(function__, "ahead", ahead, 1);
      current_statement__ = 97;
      validate_non_negative_index("xC_p", "ahead", ahead);
      current_statement__ = 98;
      validate_non_negative_index("xC_p", "nt", nt);
      current_statement__ = 99;
      context__.validate_dims("data initialization","xC_p","double",
          context__.to_vec(ahead, nt));
      xC_p = std::vector<Eigen::Matrix<double, -1, 1>>(ahead, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(xC_p, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> xC_p_flat__;
        current_statement__ = 99;
        assign(xC_p_flat__, nil_index_list(), context__.vals_r("xC_p"),
          "assigning variable xC_p_flat__");
        current_statement__ = 99;
        pos__ = 1;
        current_statement__ = 99;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 99;
          for (int sym2__ = 1; sym2__ <= ahead; ++sym2__) {
            current_statement__ = 99;
            assign(xC_p,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              xC_p_flat__[(pos__ - 1)], "assigning variable xC_p");
            current_statement__ = 99;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 100;
      validate_non_negative_index("future_rts", "ahead", ahead);
      current_statement__ = 101;
      validate_non_negative_index("future_rts", "nt", nt);
      current_statement__ = 102;
      context__.validate_dims("data initialization","future_rts","double",
          context__.to_vec(ahead, nt));
      future_rts = std::vector<Eigen::Matrix<double, -1, 1>>(ahead, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(future_rts, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> future_rts_flat__;
        current_statement__ = 102;
        assign(future_rts_flat__, nil_index_list(),
          context__.vals_r("future_rts"),
          "assigning variable future_rts_flat__");
        current_statement__ = 102;
        pos__ = 1;
        current_statement__ = 102;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 102;
          for (int sym2__ = 1; sym2__ <= ahead; ++sym2__) {
            current_statement__ = 102;
            assign(future_rts,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              future_rts_flat__[(pos__ - 1)], "assigning variable future_rts");
            current_statement__ = 102;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 103;
      context__.validate_dims("data initialization","compute_log_lik","int",
          context__.to_vec());
      compute_log_lik = std::numeric_limits<int>::min();
      
      current_statement__ = 103;
      compute_log_lik = context__.vals_i("compute_log_lik")[(1 - 1)];
      current_statement__ = 103;
      current_statement__ = 103;
      check_greater_or_equal(function__, "compute_log_lik", compute_log_lik,
                             0);
      current_statement__ = 103;
      current_statement__ = 103;
      check_less_or_equal(function__, "compute_log_lik", compute_log_lik, 1);
      current_statement__ = 104;
      validate_non_negative_index("xC_c", "ahead + max(Q, P)",
                                  (ahead + std::max(Q, P)));
      current_statement__ = 105;
      validate_non_negative_index("xC_c", "nt", nt);
      current_statement__ = 106;
      xC_c = Eigen::Matrix<double, -1, -1>((ahead + std::max(Q, P)), nt);
      stan::math::fill(xC_c, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 107;
      validate_non_negative_index("xC_m", "T", T);
      current_statement__ = 108;
      validate_non_negative_index("xC_m", "nt", nt);
      current_statement__ = 109;
      validate_non_negative_index("xC_m", "nt", nt);
      current_statement__ = 110;
      xC_m = std::vector<Eigen::Matrix<double, -1, -1>>(T, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(xC_m, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 111;
      xC_marker = std::numeric_limits<int>::min();
      
      current_statement__ = 111;
      xC_marker = 0;
      current_statement__ = 112;
      cp = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 118;
      for (int t = 1; t <= T; ++t) {
        current_statement__ = 113;
        assign(xC_m, cons_list(index_uni(t), nil_index_list()),
          diag_matrix(xC[(t - 1)]), "assigning variable xC_m");
        current_statement__ = 114;
        cp = sum(multiply(transpose(xC_m[(t - 1)]), xC_m[(t - 1)]));
        current_statement__ = 116;
        if (logical_neq(cp, 0)) {
          current_statement__ = 115;
          xC_marker = (xC_marker + 1);
        } }
      current_statement__ = 121;
      for (int i = 1; i <= std::max(Q, P); ++i) {
        current_statement__ = 119;
        assign(xC_c, cons_list(index_uni(i), nil_index_list()),
          transpose(xC[((T - (std::max(Q, P) - 1)) - 1)]),
          "assigning variable xC_c");}
      current_statement__ = 124;
      for (int i = 1; i <= ahead; ++i) {
        current_statement__ = 122;
        assign(xC_c,
          cons_list(index_uni((i + std::max(Q, P))), nil_index_list()),
          transpose(xC_p[(i - 1)]), "assigning variable xC_c");}
      current_statement__ = 111;
      current_statement__ = 111;
      check_greater_or_equal(function__, "xC_marker", xC_marker, 0);
      current_statement__ = 112;
      current_statement__ = 112;
      check_greater_or_equal(function__, "cp", cp, 0);
      current_statement__ = 125;
      validate_non_negative_index("phi0", "nt", nt);
      current_statement__ = 126;
      validate_non_negative_index("phi", "nt", nt);
      current_statement__ = 127;
      validate_non_negative_index("phi", "nt", nt);
      current_statement__ = 128;
      validate_non_negative_index("theta", "nt", nt);
      current_statement__ = 129;
      validate_non_negative_index("theta", "nt", nt);
      current_statement__ = 130;
      validate_non_negative_index("beta0", "nt", nt);
      current_statement__ = 131;
      validate_non_negative_index("beta1", "nt", nt);
      current_statement__ = 132;
      validate_non_negative_index("C_R", "nt", nt);
      current_statement__ = 132;
      validate_non_negative_index("C_R", "nt", nt);
      current_statement__ = 133;
      validate_non_negative_index("Cnst", "nt", nt);
      current_statement__ = 133;
      validate_non_negative_index("Cnst", "nt", nt);
      current_statement__ = 134;
      validate_non_negative_index("H", "T", T);
      current_statement__ = 135;
      validate_non_negative_index("H", "nt", nt);
      current_statement__ = 135;
      validate_non_negative_index("H", "nt", nt);
      current_statement__ = 136;
      rr_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 136;
      rr_1dim__ = (T - 1);
      current_statement__ = 136;
      validate_non_negative_index("rr", "T - 1", rr_1dim__);
      current_statement__ = 137;
      validate_non_negative_index("rr", "nt", nt);
      current_statement__ = 138;
      validate_non_negative_index("rr", "nt", nt);
      current_statement__ = 139;
      validate_non_negative_index("mu", "T", T);
      current_statement__ = 140;
      validate_non_negative_index("mu", "nt", nt);
      current_statement__ = 141;
      validate_non_negative_index("A", "Q", Q);
      current_statement__ = 142;
      validate_non_negative_index("A", "nt", nt);
      current_statement__ = 143;
      validate_non_negative_index("A", "nt", nt);
      current_statement__ = 144;
      validate_non_negative_index("B", "P", P);
      current_statement__ = 145;
      validate_non_negative_index("B", "nt", nt);
      current_statement__ = 146;
      validate_non_negative_index("B", "nt", nt);
      current_statement__ = 147;
      validate_non_negative_index("corH", "T", T);
      current_statement__ = 148;
      validate_non_negative_index("corH", "nt", nt);
      current_statement__ = 148;
      validate_non_negative_index("corH", "nt", nt);
      current_statement__ = 149;
      rts_p_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 149;
      rts_p_1dim__ = (ahead + std::max(Q, P));
      current_statement__ = 149;
      validate_non_negative_index("rts_p", "ahead + max(Q, P)", rts_p_1dim__);
      current_statement__ = 150;
      validate_non_negative_index("rts_p", "nt", nt);
      current_statement__ = 151;
      validate_non_negative_index("rts_forecasted", "ahead", ahead);
      current_statement__ = 152;
      validate_non_negative_index("rts_forecasted", "nt", nt);
      current_statement__ = 153;
      H_p_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 153;
      H_p_1dim__ = (ahead + std::max(Q, P));
      current_statement__ = 153;
      validate_non_negative_index("H_p", "ahead + max(Q, P)", H_p_1dim__);
      current_statement__ = 154;
      validate_non_negative_index("H_p", "nt", nt);
      current_statement__ = 154;
      validate_non_negative_index("H_p", "nt", nt);
      current_statement__ = 155;
      R_p_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 155;
      R_p_1dim__ = (ahead + std::max(Q, P));
      current_statement__ = 155;
      validate_non_negative_index("R_p", "ahead + max(Q, P)", R_p_1dim__);
      current_statement__ = 156;
      validate_non_negative_index("R_p", "nt", nt);
      current_statement__ = 156;
      validate_non_negative_index("R_p", "nt", nt);
      current_statement__ = 157;
      validate_non_negative_index("H_forecasted", "ahead", ahead);
      current_statement__ = 158;
      validate_non_negative_index("H_forecasted", "nt", nt);
      current_statement__ = 158;
      validate_non_negative_index("H_forecasted", "nt", nt);
      current_statement__ = 159;
      validate_non_negative_index("R_forecasted", "ahead", ahead);
      current_statement__ = 160;
      validate_non_negative_index("R_forecasted", "nt", nt);
      current_statement__ = 160;
      validate_non_negative_index("R_forecasted", "nt", nt);
      current_statement__ = 161;
      rr_p_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 161;
      rr_p_1dim__ = (ahead + std::max(Q, P));
      current_statement__ = 161;
      validate_non_negative_index("rr_p", "ahead + max(Q, P)", rr_p_1dim__);
      current_statement__ = 162;
      validate_non_negative_index("rr_p", "nt", nt);
      current_statement__ = 163;
      validate_non_negative_index("rr_p", "nt", nt);
      current_statement__ = 164;
      mu_p_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 164;
      mu_p_1dim__ = (ahead + std::max(Q, P));
      current_statement__ = 164;
      validate_non_negative_index("mu_p", "ahead + max(Q, P)", mu_p_1dim__);
      current_statement__ = 165;
      validate_non_negative_index("mu_p", "nt", nt);
      current_statement__ = 166;
      validate_non_negative_index("mu_forecasted", "ahead", ahead);
      current_statement__ = 167;
      validate_non_negative_index("mu_forecasted", "nt", nt);
      current_statement__ = 168;
      beta_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 168;
      beta_1dim__ = (nt + 1);
      current_statement__ = 168;
      validate_non_negative_index("beta", "nt + 1", beta_1dim__);
      current_statement__ = 169;
      validate_non_negative_index("beta", "nt", nt);
      current_statement__ = 170;
      log_lik_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 170;
      log_lik_1dim__ = (logical_eq(compute_log_lik, 1) ? ahead : 0);
      current_statement__ = 170;
      validate_non_negative_index("log_lik",
                                  "compute_log_lik == 1 ? ahead : 0",
                                  log_lik_1dim__);
      current_statement__ = 171;
      validate_non_negative_index("A_part_p", "nt", nt);
      current_statement__ = 172;
      validate_non_negative_index("A_part_p", "nt", nt);
      current_statement__ = 173;
      validate_non_negative_index("B_part_p", "nt", nt);
      current_statement__ = 174;
      validate_non_negative_index("B_part_p", "nt", nt);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += nt;
      num_params_r__ += nt * nt;
      num_params_r__ += nt * nt;
      num_params_r__ += nt;
      num_params_r__ += nt;
      num_params_r__ += ((nt * (nt - 1)) / 2);
      num_params_r__ += 1;
      num_params_r__ += (nt + ((nt * (nt - 1)) / 2));
      num_params_r__ += T * (nt + ((nt * (nt - 1)) / 2));
      num_params_r__ += rr_1dim__ * nt * nt;
      num_params_r__ += T * nt;
      num_params_r__ += Q * nt * nt;
      num_params_r__ += P * nt * nt;
      num_params_r__ += T * ((nt * (nt - 1)) / 2);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_forecastBEKK_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> phi0;
      phi0 = Eigen::Matrix<local_scalar_t__, -1, 1>(nt);
      stan::math::fill(phi0, DUMMY_VAR__);
      
      current_statement__ = 1;
      phi0 = in__.vector(nt);
      Eigen::Matrix<local_scalar_t__, -1, -1> phi;
      phi = Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt);
      stan::math::fill(phi, DUMMY_VAR__);
      
      current_statement__ = 2;
      phi = in__.matrix(nt, nt);
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 2;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 2;
          if (jacobian__) {
            current_statement__ = 2;
            assign(phi,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lub_constrain(
                rvalue(phi,
                  cons_list(index_uni(sym1__),
                    cons_list(index_uni(sym2__), nil_index_list())), "phi"),
                -1, 1, lp__), "assigning variable phi");
          } else {
            current_statement__ = 2;
            assign(phi,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lub_constrain(
                rvalue(phi,
                  cons_list(index_uni(sym1__),
                    cons_list(index_uni(sym2__), nil_index_list())), "phi"),
                -1, 1), "assigning variable phi");
          }}}
      Eigen::Matrix<local_scalar_t__, -1, -1> theta;
      theta = Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt);
      stan::math::fill(theta, DUMMY_VAR__);
      
      current_statement__ = 3;
      theta = in__.matrix(nt, nt);
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 3;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 3;
          if (jacobian__) {
            current_statement__ = 3;
            assign(theta,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lub_constrain(
                rvalue(theta,
                  cons_list(index_uni(sym1__),
                    cons_list(index_uni(sym2__), nil_index_list())), "theta"),
                -1, 1, lp__), "assigning variable theta");
          } else {
            current_statement__ = 3;
            assign(theta,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lub_constrain(
                rvalue(theta,
                  cons_list(index_uni(sym1__),
                    cons_list(index_uni(sym2__), nil_index_list())), "theta"),
                -1, 1), "assigning variable theta");
          }}}
      Eigen::Matrix<local_scalar_t__, 1, -1> beta0;
      beta0 = Eigen::Matrix<local_scalar_t__, 1, -1>(nt);
      stan::math::fill(beta0, DUMMY_VAR__);
      
      current_statement__ = 4;
      beta0 = in__.row_vector(nt);
      Eigen::Matrix<local_scalar_t__, -1, 1> beta1;
      beta1 = Eigen::Matrix<local_scalar_t__, -1, 1>(nt);
      stan::math::fill(beta1, DUMMY_VAR__);
      
      current_statement__ = 5;
      beta1 = in__.vector(nt);
      Eigen::Matrix<local_scalar_t__, -1, -1> C_R;
      C_R = Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt);
      stan::math::fill(C_R, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> C_R_in__;
      C_R_in__ = Eigen::Matrix<local_scalar_t__, -1, 1>(((nt * (nt - 1)) / 2));
      stan::math::fill(C_R_in__, DUMMY_VAR__);
      
      current_statement__ = 6;
      C_R_in__ = in__.vector(((nt * (nt - 1)) / 2));
      current_statement__ = 6;
      if (jacobian__) {
        current_statement__ = 6;
        assign(C_R, nil_index_list(),
          stan::math::corr_matrix_constrain(C_R_in__, nt, lp__),
          "assigning variable C_R");
      } else {
        current_statement__ = 6;
        assign(C_R, nil_index_list(),
          stan::math::corr_matrix_constrain(C_R_in__, nt),
          "assigning variable C_R");
      }
      local_scalar_t__ nu;
      nu = DUMMY_VAR__;
      
      current_statement__ = 7;
      nu = in__.scalar();
      current_statement__ = 7;
      if (jacobian__) {
        current_statement__ = 7;
        nu = stan::math::lb_constrain(nu, 2, lp__);
      } else {
        current_statement__ = 7;
        nu = stan::math::lb_constrain(nu, 2);
      }
      Eigen::Matrix<local_scalar_t__, -1, -1> Cnst;
      Cnst = Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt);
      stan::math::fill(Cnst, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> Cnst_in__;
      Cnst_in__ = Eigen::Matrix<local_scalar_t__, -1, 1>((nt +
                                                           ((nt * (nt - 1)) /
                                                             2)));
      stan::math::fill(Cnst_in__, DUMMY_VAR__);
      
      current_statement__ = 8;
      Cnst_in__ = in__.vector((nt + ((nt * (nt - 1)) / 2)));
      current_statement__ = 8;
      if (jacobian__) {
        current_statement__ = 8;
        assign(Cnst, nil_index_list(),
          stan::math::cov_matrix_constrain(Cnst_in__, nt, lp__),
          "assigning variable Cnst");
      } else {
        current_statement__ = 8;
        assign(Cnst, nil_index_list(),
          stan::math::cov_matrix_constrain(Cnst_in__, nt),
          "assigning variable Cnst");
      }
      std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>> H;
      H = std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>>(T, Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt));
      stan::math::fill(H, DUMMY_VAR__);
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> H_in__;
      H_in__ = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(T, Eigen::Matrix<local_scalar_t__, -1, 1>(
        (nt + ((nt * (nt - 1)) / 2))));
      stan::math::fill(H_in__, DUMMY_VAR__);
      
      current_statement__ = 9;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 9;
        assign(H_in__, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector((nt + ((nt * (nt - 1)) / 2))),
          "assigning variable H_in__");}
      current_statement__ = 9;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 9;
        if (jacobian__) {
          current_statement__ = 9;
          assign(H, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::cov_matrix_constrain(H_in__[(sym1__ - 1)], nt, lp__),
            "assigning variable H");
        } else {
          current_statement__ = 9;
          assign(H, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::cov_matrix_constrain(H_in__[(sym1__ - 1)], nt),
            "assigning variable H");
        }}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>> rr;
      rr = std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>>(rr_1dim__, Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt));
      stan::math::fill(rr, DUMMY_VAR__);
      
      current_statement__ = 10;
      for (int sym1__ = 1; sym1__ <= rr_1dim__; ++sym1__) {
        current_statement__ = 10;
        assign(rr, cons_list(index_uni(sym1__), nil_index_list()),
          in__.matrix(nt, nt), "assigning variable rr");}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> mu;
      mu = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(T, Eigen::Matrix<local_scalar_t__, -1, 1>(nt));
      stan::math::fill(mu, DUMMY_VAR__);
      
      current_statement__ = 11;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 11;
        assign(mu, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nt), "assigning variable mu");}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>> A;
      A = std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>>(Q, Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt));
      stan::math::fill(A, DUMMY_VAR__);
      
      current_statement__ = 12;
      for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
        current_statement__ = 12;
        assign(A, cons_list(index_uni(sym1__), nil_index_list()),
          in__.matrix(nt, nt), "assigning variable A");}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>> B;
      B = std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>>(P, Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt));
      stan::math::fill(B, DUMMY_VAR__);
      
      current_statement__ = 13;
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        current_statement__ = 13;
        assign(B, cons_list(index_uni(sym1__), nil_index_list()),
          in__.matrix(nt, nt), "assigning variable B");}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>> corH;
      corH = std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>>(T, Eigen::Matrix<local_scalar_t__, -1, -1>(nt, nt));
      stan::math::fill(corH, DUMMY_VAR__);
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> corH_in__;
      corH_in__ = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(T, Eigen::Matrix<local_scalar_t__, -1, 1>(
        ((nt * (nt - 1)) / 2)));
      stan::math::fill(corH_in__, DUMMY_VAR__);
      
      current_statement__ = 14;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 14;
        assign(corH_in__, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(((nt * (nt - 1)) / 2)), "assigning variable corH_in__");
      }
      current_statement__ = 14;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 14;
        if (jacobian__) {
          current_statement__ = 14;
          assign(corH, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::corr_matrix_constrain(corH_in__[(sym1__ - 1)], nt,
              lp__), "assigning variable corH");
        } else {
          current_statement__ = 14;
          assign(corH, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::corr_matrix_constrain(corH_in__[(sym1__ - 1)], nt),
            "assigning variable corH");
        }}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_forecastBEKK_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> phi0;
      phi0 = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(phi0, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      phi0 = in__.vector(nt);
      Eigen::Matrix<double, -1, -1> phi;
      phi = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(phi, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      phi = in__.matrix(nt, nt);
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 2;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 2;
          assign(phi,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lub_constrain(
              rvalue(phi,
                cons_list(index_uni(sym1__),
                  cons_list(index_uni(sym2__), nil_index_list())), "phi"),
              -1, 1), "assigning variable phi");}}
      Eigen::Matrix<double, -1, -1> theta;
      theta = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(theta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      theta = in__.matrix(nt, nt);
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 3;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 3;
          assign(theta,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lub_constrain(
              rvalue(theta,
                cons_list(index_uni(sym1__),
                  cons_list(index_uni(sym2__), nil_index_list())), "theta"),
              -1, 1), "assigning variable theta");}}
      Eigen::Matrix<double, 1, -1> beta0;
      beta0 = Eigen::Matrix<double, 1, -1>(nt);
      stan::math::fill(beta0, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      beta0 = in__.row_vector(nt);
      Eigen::Matrix<double, -1, 1> beta1;
      beta1 = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(beta1, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      beta1 = in__.vector(nt);
      Eigen::Matrix<double, -1, -1> C_R;
      C_R = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(C_R, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<local_scalar_t__, -1, 1> C_R_in__;
      C_R_in__ = Eigen::Matrix<local_scalar_t__, -1, 1>(((nt * (nt - 1)) / 2));
      stan::math::fill(C_R_in__, DUMMY_VAR__);
      
      current_statement__ = 6;
      C_R_in__ = in__.vector(((nt * (nt - 1)) / 2));
      current_statement__ = 6;
      assign(C_R, nil_index_list(),
        stan::math::corr_matrix_constrain(C_R_in__, nt),
        "assigning variable C_R");
      double nu;
      nu = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      nu = in__.scalar();
      current_statement__ = 7;
      nu = stan::math::lb_constrain(nu, 2);
      Eigen::Matrix<double, -1, -1> Cnst;
      Cnst = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(Cnst, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<local_scalar_t__, -1, 1> Cnst_in__;
      Cnst_in__ = Eigen::Matrix<local_scalar_t__, -1, 1>((nt +
                                                           ((nt * (nt - 1)) /
                                                             2)));
      stan::math::fill(Cnst_in__, DUMMY_VAR__);
      
      current_statement__ = 8;
      Cnst_in__ = in__.vector((nt + ((nt * (nt - 1)) / 2)));
      current_statement__ = 8;
      assign(Cnst, nil_index_list(),
        stan::math::cov_matrix_constrain(Cnst_in__, nt),
        "assigning variable Cnst");
      std::vector<Eigen::Matrix<double, -1, -1>> H;
      H = std::vector<Eigen::Matrix<double, -1, -1>>(T, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(H, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> H_in__;
      H_in__ = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(T, Eigen::Matrix<local_scalar_t__, -1, 1>(
        (nt + ((nt * (nt - 1)) / 2))));
      stan::math::fill(H_in__, DUMMY_VAR__);
      
      current_statement__ = 9;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 9;
        assign(H_in__, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector((nt + ((nt * (nt - 1)) / 2))),
          "assigning variable H_in__");}
      current_statement__ = 9;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 9;
        assign(H, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::cov_matrix_constrain(H_in__[(sym1__ - 1)], nt),
          "assigning variable H");}
      std::vector<Eigen::Matrix<double, -1, -1>> rr;
      rr = std::vector<Eigen::Matrix<double, -1, -1>>(rr_1dim__, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(rr, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 10;
      for (int sym1__ = 1; sym1__ <= rr_1dim__; ++sym1__) {
        current_statement__ = 10;
        assign(rr, cons_list(index_uni(sym1__), nil_index_list()),
          in__.matrix(nt, nt), "assigning variable rr");}
      std::vector<Eigen::Matrix<double, -1, 1>> mu;
      mu = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(mu, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 11;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 11;
        assign(mu, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nt), "assigning variable mu");}
      std::vector<Eigen::Matrix<double, -1, -1>> A;
      A = std::vector<Eigen::Matrix<double, -1, -1>>(Q, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(A, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 12;
      for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
        current_statement__ = 12;
        assign(A, cons_list(index_uni(sym1__), nil_index_list()),
          in__.matrix(nt, nt), "assigning variable A");}
      std::vector<Eigen::Matrix<double, -1, -1>> B;
      B = std::vector<Eigen::Matrix<double, -1, -1>>(P, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(B, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 13;
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        current_statement__ = 13;
        assign(B, cons_list(index_uni(sym1__), nil_index_list()),
          in__.matrix(nt, nt), "assigning variable B");}
      std::vector<Eigen::Matrix<double, -1, -1>> corH;
      corH = std::vector<Eigen::Matrix<double, -1, -1>>(T, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(corH, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> corH_in__;
      corH_in__ = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(T, Eigen::Matrix<local_scalar_t__, -1, 1>(
        ((nt * (nt - 1)) / 2)));
      stan::math::fill(corH_in__, DUMMY_VAR__);
      
      current_statement__ = 14;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 14;
        assign(corH_in__, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(((nt * (nt - 1)) / 2)), "assigning variable corH_in__");
      }
      current_statement__ = 14;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 14;
        assign(corH, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::corr_matrix_constrain(corH_in__[(sym1__ - 1)], nt),
          "assigning variable corH");}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(phi0[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(
            rvalue(phi,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "phi"));}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(
            rvalue(theta,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "theta"));}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(beta0[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(beta1[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(
            rvalue(C_R,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "C_R"));}}
      vars__.emplace_back(nu);
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(
            rvalue(Cnst,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "Cnst"));}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= T; ++sym3__) {
            vars__.emplace_back(
              rvalue(H,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))), "H"));}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= rr_1dim__; ++sym3__) {
            vars__.emplace_back(
              rvalue(rr,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))), "rr"));
          }}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
          vars__.emplace_back(mu[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= Q; ++sym3__) {
            vars__.emplace_back(
              rvalue(A,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))), "A"));}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= P; ++sym3__) {
            vars__.emplace_back(
              rvalue(B,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))), "B"));}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= T; ++sym3__) {
            vars__.emplace_back(
              rvalue(corH,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))), "corH"));
          }}}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      std::vector<Eigen::Matrix<double, -1, 1>> rts_p;
      rts_p = std::vector<Eigen::Matrix<double, -1, 1>>(rts_p_1dim__, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(rts_p, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> rts_forecasted;
      rts_forecasted = std::vector<Eigen::Matrix<double, -1, 1>>(ahead, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(rts_forecasted, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, -1>> H_p;
      H_p = std::vector<Eigen::Matrix<double, -1, -1>>(H_p_1dim__, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(H_p, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, -1>> R_p;
      R_p = std::vector<Eigen::Matrix<double, -1, -1>>(R_p_1dim__, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(R_p, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, -1>> H_forecasted;
      H_forecasted = std::vector<Eigen::Matrix<double, -1, -1>>(ahead, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(H_forecasted, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, -1>> R_forecasted;
      R_forecasted = std::vector<Eigen::Matrix<double, -1, -1>>(ahead, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(R_forecasted, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, -1>> rr_p;
      rr_p = std::vector<Eigen::Matrix<double, -1, -1>>(rr_p_1dim__, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(rr_p, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> mu_p;
      mu_p = std::vector<Eigen::Matrix<double, -1, 1>>(mu_p_1dim__, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(mu_p, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> mu_forecasted;
      mu_forecasted = std::vector<Eigen::Matrix<double, -1, 1>>(ahead, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(mu_forecasted, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> beta;
      beta = Eigen::Matrix<double, -1, -1>(beta_1dim__, nt);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 24;
      assign(beta, nil_index_list(), append_row(beta0, diag_matrix(beta1)),
        "assigning variable beta");
      std::vector<double> log_lik;
      log_lik = std::vector<double>(log_lik_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> A_part_p;
      A_part_p = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(A_part_p, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> B_part_p;
      B_part_p = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(B_part_p, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 28;
      assign(rts_p,
        cons_list(index_min_max(1, (ahead + std::max(Q, P))),
          cons_list(index_omni(), nil_index_list())),
        rvalue(rts,
          cons_list(index_min_max(1, (ahead + std::max(Q, P))),
            cons_list(index_omni(), nil_index_list())), "rts"),
        "assigning variable rts_p");
      current_statement__ = 29;
      assign(H_p,
        cons_list(index_min_max(1, (ahead + std::max(Q, P))),
          cons_list(index_omni(), nil_index_list())),
        rvalue(H,
          cons_list(index_min_max(1, (ahead + std::max(Q, P))),
            cons_list(index_omni(), nil_index_list())), "H"),
        "assigning variable H_p");
      current_statement__ = 30;
      assign(mu_p,
        cons_list(index_min_max(1, (ahead + std::max(Q, P))),
          cons_list(index_omni(), nil_index_list())),
        rvalue(mu,
          cons_list(index_min_max(1, (ahead + std::max(Q, P))),
            cons_list(index_omni(), nil_index_list())), "mu"),
        "assigning variable mu_p");
      current_statement__ = 31;
      assign(rr_p,
        cons_list(index_min_max(1, (ahead + std::max(Q, P))),
          cons_list(index_omni(), nil_index_list())),
        rvalue(rr,
          cons_list(index_min_max(1, (ahead + std::max(Q, P))),
            cons_list(index_omni(), nil_index_list())), "rr"),
        "assigning variable rr_p");
      current_statement__ = 32;
      assign(R_p,
        cons_list(index_min_max(1, (ahead + std::max(Q, P))),
          cons_list(index_omni(), nil_index_list())),
        rvalue(corH,
          cons_list(index_min_max(1, (ahead + std::max(Q, P))),
            cons_list(index_omni(), nil_index_list())), "corH"),
        "assigning variable R_p");
      current_statement__ = 33;
      assign(rts_p,
        cons_list(index_min_max(1, std::max(Q, P)),
          cons_list(index_omni(), nil_index_list())),
        rvalue(rts,
          cons_list(index_min_max((T - (std::max(Q, P) - 1)), T),
            cons_list(index_omni(), nil_index_list())), "rts"),
        "assigning variable rts_p");
      current_statement__ = 34;
      assign(H_p,
        cons_list(index_min_max(1, std::max(Q, P)),
          cons_list(index_omni(), nil_index_list())),
        rvalue(H,
          cons_list(index_min_max((T - (std::max(Q, P) - 1)), T),
            cons_list(index_omni(), nil_index_list())), "H"),
        "assigning variable H_p");
      current_statement__ = 35;
      assign(mu_p,
        cons_list(index_min_max(1, std::max(Q, P)),
          cons_list(index_omni(), nil_index_list())),
        rvalue(mu,
          cons_list(index_min_max((T - (std::max(Q, P) - 1)), T),
            cons_list(index_omni(), nil_index_list())), "mu"),
        "assigning variable mu_p");
      current_statement__ = 36;
      assign(rr_p,
        cons_list(index_min_max(1, std::max(Q, P)),
          cons_list(index_omni(), nil_index_list())),
        rvalue(rr,
          cons_list(index_min_max(((T - 1) - (std::max(Q, P) - 1)), (T - 1)),
            cons_list(index_omni(), nil_index_list())), "rr"),
        "assigning variable rr_p");
      current_statement__ = 37;
      assign(R_p,
        cons_list(index_min_max(1, std::max(Q, P)),
          cons_list(index_omni(), nil_index_list())),
        rvalue(corH,
          cons_list(index_min_max((T - (std::max(Q, P) - 1)), T),
            cons_list(index_omni(), nil_index_list())), "corH"),
        "assigning variable R_p");
      current_statement__ = 67;
      for (int t = (std::max(Q, P) + 1); t <= (std::max(Q, P) + ahead); ++t) {
        current_statement__ = 38;
        assign(A_part_p, nil_index_list(), diag_matrix(rep_vector(0.0, nt)),
          "assigning variable A_part_p");
        current_statement__ = 39;
        assign(B_part_p, nil_index_list(), diag_matrix(rep_vector(0.0, nt)),
          "assigning variable B_part_p");
        current_statement__ = 45;
        if (logical_eq(meanstructure, 0)) {
          current_statement__ = 43;
          assign(mu_p,
            cons_list(index_uni(t),
              cons_list(index_omni(), nil_index_list())), phi0,
            "assigning variable mu_p");
        } else {
          current_statement__ = 42;
          if (logical_eq(meanstructure, 1)) {
            current_statement__ = 40;
            assign(mu_p,
              cons_list(index_uni(t),
                cons_list(index_omni(), nil_index_list())),
              add(
                add(phi0,
                  multiply(phi,
                    rvalue(rts_p,
                      cons_list(index_uni((t - 1)),
                        cons_list(index_omni(), nil_index_list())), "rts_p"))),
                multiply(theta,
                  subtract(
                    rvalue(rts_p,
                      cons_list(index_uni((t - 1)),
                        cons_list(index_omni(), nil_index_list())), "rts_p"),
                    stan::model::deep_copy(
                      rvalue(mu_p,
                        cons_list(index_uni((t - 1)),
                          cons_list(index_omni(), nil_index_list())), "mu_p"))))),
              "assigning variable mu_p");
          } 
        }
        current_statement__ = 49;
        for (int q = 1; q <= std::min((t - 1), Q); ++q) {
          current_statement__ = 46;
          assign(rr_p,
            cons_list(index_uni((t - q)),
              cons_list(index_omni(), nil_index_list())),
            multiply(
              subtract(
                rvalue(rts_p,
                  cons_list(index_uni((t - q)),
                    cons_list(index_omni(), nil_index_list())), "rts_p"),
                rvalue(mu_p,
                  cons_list(index_uni((t - q)),
                    cons_list(index_omni(), nil_index_list())), "mu_p")),
              transpose(
                subtract(
                  rvalue(rts_p,
                    cons_list(index_uni((t - q)),
                      cons_list(index_omni(), nil_index_list())), "rts_p"),
                  rvalue(mu_p,
                    cons_list(index_uni((t - q)),
                      cons_list(index_omni(), nil_index_list())), "mu_p")))),
            "assigning variable rr_p");
          current_statement__ = 47;
          assign(A_part_p, nil_index_list(),
            add(stan::model::deep_copy(A_part_p),
              multiply(
                multiply(transpose(A[(q - 1)]),
                  rvalue(rr_p,
                    cons_list(index_uni((t - q)),
                      cons_list(index_omni(), nil_index_list())), "rr_p")),
                A[(q - 1)])), "assigning variable A_part_p");}
        current_statement__ = 52;
        for (int p = 1; p <= std::min((t - 1), P); ++p) {
          current_statement__ = 50;
          assign(B_part_p, nil_index_list(),
            add(stan::model::deep_copy(B_part_p),
              multiply(
                multiply(transpose(B[(p - 1)]),
                  rvalue(H_p,
                    cons_list(index_uni((t - p)),
                      cons_list(index_omni(), nil_index_list())), "H_p")),
                B[(p - 1)])), "assigning variable B_part_p");}
        current_statement__ = 58;
        if (logical_eq(xC_marker, 0)) {
          current_statement__ = 56;
          assign(H_p,
            cons_list(index_uni(t),
              cons_list(index_omni(), nil_index_list())),
            add(add(quad_form_diag(C_R, stan::math::exp(beta0)), A_part_p),
              B_part_p), "assigning variable H_p");
        } else {
          current_statement__ = 55;
          if (logical_gte(xC_marker, 1)) {
            current_statement__ = 53;
            assign(H_p,
              cons_list(index_uni(t),
                cons_list(index_omni(), nil_index_list())),
              add(
                add(
                  quad_form_diag(C_R,
                    stan::math::exp(
                      multiply(
                        append_col(1.0,
                          rvalue(xC_c,
                            cons_list(index_uni(t),
                              cons_list(index_omni(), nil_index_list())),
                            "xC_c")), beta))), A_part_p), B_part_p),
              "assigning variable H_p");
          } 
        }
        current_statement__ = 59;
        assign(R_p,
          cons_list(index_uni(t), cons_list(index_omni(), nil_index_list())),
          cov2cor(
            rvalue(H_p,
              cons_list(index_uni(t),
                cons_list(index_omni(), nil_index_list())), "H_p"), pstream__),
          "assigning variable R_p");
        current_statement__ = 65;
        if (logical_eq(distribution, 0)) {
          current_statement__ = 63;
          assign(rts_p,
            cons_list(index_uni(t),
              cons_list(index_omni(), nil_index_list())),
            multi_normal_rng(
              rvalue(mu_p,
                cons_list(index_uni(t),
                  cons_list(index_omni(), nil_index_list())), "mu_p"),
              rvalue(H_p,
                cons_list(index_uni(t),
                  cons_list(index_omni(), nil_index_list())), "H_p"),
              base_rng__), "assigning variable rts_p");
        } else {
          current_statement__ = 62;
          if (logical_eq(distribution, 1)) {
            current_statement__ = 60;
            assign(rts_p,
              cons_list(index_uni(t),
                cons_list(index_omni(), nil_index_list())),
              multi_student_t_rng(nu,
                rvalue(mu_p,
                  cons_list(index_uni(t),
                    cons_list(index_omni(), nil_index_list())), "mu_p"),
                rvalue(H_p,
                  cons_list(index_uni(t),
                    cons_list(index_omni(), nil_index_list())), "H_p"),
                base_rng__), "assigning variable rts_p");
          } 
        }}
      current_statement__ = 68;
      assign(rts_forecasted, nil_index_list(),
        rvalue(rts_p,
          cons_list(
            index_min_max((std::max(Q, P) + 1), (std::max(Q, P) + ahead)),
            nil_index_list()), "rts_p"), "assigning variable rts_forecasted");
      current_statement__ = 69;
      assign(H_forecasted, nil_index_list(),
        rvalue(H_p,
          cons_list(
            index_min_max((std::max(Q, P) + 1), (std::max(Q, P) + ahead)),
            nil_index_list()), "H_p"), "assigning variable H_forecasted");
      current_statement__ = 70;
      assign(R_forecasted, nil_index_list(),
        rvalue(R_p,
          cons_list(
            index_min_max((std::max(Q, P) + 1), (std::max(Q, P) + ahead)),
            nil_index_list()), "R_p"), "assigning variable R_forecasted");
      current_statement__ = 71;
      assign(mu_forecasted, nil_index_list(),
        rvalue(mu_p,
          cons_list(
            index_min_max((std::max(Q, P) + 1), (std::max(Q, P) + ahead)),
            nil_index_list()), "mu_p"), "assigning variable mu_forecasted");
      current_statement__ = 83;
      if (compute_log_lik) {
        current_statement__ = 81;
        if (logical_eq(distribution, 0)) {
          current_statement__ = 79;
          for (int i = 1; i <= ahead; ++i) {
            current_statement__ = 77;
            assign(log_lik, cons_list(index_uni(i), nil_index_list()),
              multi_normal_lpdf<false>(future_rts[(i - 1)],
                mu_forecasted[(i - 1)], H_forecasted[(i - 1)]),
              "assigning variable log_lik");}
        } else {
          current_statement__ = 76;
          if (logical_eq(distribution, 1)) {
            current_statement__ = 74;
            for (int i = 1; i <= ahead; ++i) {
              current_statement__ = 72;
              assign(log_lik, cons_list(index_uni(i), nil_index_list()),
                multi_student_t_lpdf<false>(future_rts[(i - 1)], nu,
                  mu_forecasted[(i - 1)], H_forecasted[(i - 1)]),
                "assigning variable log_lik");}
          } 
        }
      } 
      current_statement__ = 17;
      for (int sym1__ = 1; sym1__ <= H_p_1dim__; ++sym1__) {
        current_statement__ = 17;
        current_statement__ = 17;
        check_cov_matrix(function__, "H_p[sym1__]", H_p[(sym1__ - 1)]);}
      current_statement__ = 18;
      for (int sym1__ = 1; sym1__ <= R_p_1dim__; ++sym1__) {
        current_statement__ = 18;
        current_statement__ = 18;
        check_corr_matrix(function__, "R_p[sym1__]", R_p[(sym1__ - 1)]);}
      current_statement__ = 19;
      for (int sym1__ = 1; sym1__ <= ahead; ++sym1__) {
        current_statement__ = 19;
        current_statement__ = 19;
        check_cov_matrix(function__, "H_forecasted[sym1__]",
                         H_forecasted[(sym1__ - 1)]);}
      current_statement__ = 20;
      for (int sym1__ = 1; sym1__ <= ahead; ++sym1__) {
        current_statement__ = 20;
        current_statement__ = 20;
        check_corr_matrix(function__, "R_forecasted[sym1__]",
                          R_forecasted[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= rts_p_1dim__; ++sym2__) {
          vars__.emplace_back(rts_p[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= ahead; ++sym2__) {
          vars__.emplace_back(rts_forecasted[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= H_p_1dim__; ++sym3__) {
            vars__.emplace_back(
              rvalue(H_p,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))), "H_p"));
          }}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= R_p_1dim__; ++sym3__) {
            vars__.emplace_back(
              rvalue(R_p,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))), "R_p"));
          }}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= ahead; ++sym3__) {
            vars__.emplace_back(
              rvalue(H_forecasted,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                "H_forecasted"));}}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= ahead; ++sym3__) {
            vars__.emplace_back(
              rvalue(R_forecasted,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                "R_forecasted"));}}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= rr_p_1dim__; ++sym3__) {
            vars__.emplace_back(
              rvalue(rr_p,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))), "rr_p"));
          }}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= mu_p_1dim__; ++sym2__) {
          vars__.emplace_back(mu_p[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= ahead; ++sym2__) {
          vars__.emplace_back(mu_forecasted[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= beta_1dim__; ++sym2__) {
          vars__.emplace_back(
            rvalue(beta,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "beta"));}}
      for (int sym1__ = 1; sym1__ <= log_lik_1dim__; ++sym1__) {
        vars__.emplace_back(log_lik[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(
            rvalue(A_part_p,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "A_part_p"));
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(
            rvalue(B_part_p,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "B_part_p"));
        }}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> phi0;
      phi0 = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(phi0, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> phi0_flat__;
        current_statement__ = 1;
        assign(phi0_flat__, nil_index_list(), context__.vals_r("phi0"),
          "assigning variable phi0_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 1;
          assign(phi0, cons_list(index_uni(sym1__), nil_index_list()),
            phi0_flat__[(pos__ - 1)], "assigning variable phi0");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, -1> phi;
      phi = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(phi, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> phi_flat__;
        current_statement__ = 2;
        assign(phi_flat__, nil_index_list(), context__.vals_r("phi"),
          "assigning variable phi_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 2;
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            current_statement__ = 2;
            assign(phi,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              phi_flat__[(pos__ - 1)], "assigning variable phi");
            current_statement__ = 2;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, -1> phi_free__;
      phi_free__ = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(phi_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 2;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 2;
          assign(phi_free__,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lub_free(
              rvalue(phi,
                cons_list(index_uni(sym1__),
                  cons_list(index_uni(sym2__), nil_index_list())), "phi"),
              -1, 1), "assigning variable phi_free__");}}
      Eigen::Matrix<double, -1, -1> theta;
      theta = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(theta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> theta_flat__;
        current_statement__ = 3;
        assign(theta_flat__, nil_index_list(), context__.vals_r("theta"),
          "assigning variable theta_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 3;
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            current_statement__ = 3;
            assign(theta,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              theta_flat__[(pos__ - 1)], "assigning variable theta");
            current_statement__ = 3;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, -1> theta_free__;
      theta_free__ = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(theta_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        current_statement__ = 3;
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          current_statement__ = 3;
          assign(theta_free__,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lub_free(
              rvalue(theta,
                cons_list(index_uni(sym1__),
                  cons_list(index_uni(sym2__), nil_index_list())), "theta"),
              -1, 1), "assigning variable theta_free__");}}
      Eigen::Matrix<double, 1, -1> beta0;
      beta0 = Eigen::Matrix<double, 1, -1>(nt);
      stan::math::fill(beta0, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta0_flat__;
        current_statement__ = 4;
        assign(beta0_flat__, nil_index_list(), context__.vals_r("beta0"),
          "assigning variable beta0_flat__");
        current_statement__ = 4;
        pos__ = 1;
        current_statement__ = 4;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 4;
          assign(beta0, cons_list(index_uni(sym1__), nil_index_list()),
            beta0_flat__[(pos__ - 1)], "assigning variable beta0");
          current_statement__ = 4;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> beta1;
      beta1 = Eigen::Matrix<double, -1, 1>(nt);
      stan::math::fill(beta1, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta1_flat__;
        current_statement__ = 5;
        assign(beta1_flat__, nil_index_list(), context__.vals_r("beta1"),
          "assigning variable beta1_flat__");
        current_statement__ = 5;
        pos__ = 1;
        current_statement__ = 5;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 5;
          assign(beta1, cons_list(index_uni(sym1__), nil_index_list()),
            beta1_flat__[(pos__ - 1)], "assigning variable beta1");
          current_statement__ = 5;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, -1> C_R;
      C_R = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(C_R, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> C_R_flat__;
        current_statement__ = 6;
        assign(C_R_flat__, nil_index_list(), context__.vals_r("C_R"),
          "assigning variable C_R_flat__");
        current_statement__ = 6;
        pos__ = 1;
        current_statement__ = 6;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 6;
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            current_statement__ = 6;
            assign(C_R,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              C_R_flat__[(pos__ - 1)], "assigning variable C_R");
            current_statement__ = 6;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, 1> C_R_free__;
      C_R_free__ = Eigen::Matrix<double, -1, 1>(((nt * (nt - 1)) / 2));
      stan::math::fill(C_R_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 6;
      assign(C_R_free__, nil_index_list(), stan::math::corr_matrix_free(C_R),
        "assigning variable C_R_free__");
      double nu;
      nu = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      nu = context__.vals_r("nu")[(1 - 1)];
      double nu_free__;
      nu_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      nu_free__ = stan::math::lb_free(nu, 2);
      Eigen::Matrix<double, -1, -1> Cnst;
      Cnst = Eigen::Matrix<double, -1, -1>(nt, nt);
      stan::math::fill(Cnst, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> Cnst_flat__;
        current_statement__ = 8;
        assign(Cnst_flat__, nil_index_list(), context__.vals_r("Cnst"),
          "assigning variable Cnst_flat__");
        current_statement__ = 8;
        pos__ = 1;
        current_statement__ = 8;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 8;
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            current_statement__ = 8;
            assign(Cnst,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              Cnst_flat__[(pos__ - 1)], "assigning variable Cnst");
            current_statement__ = 8;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, 1> Cnst_free__;
      Cnst_free__ = Eigen::Matrix<double, -1, 1>((nt + ((nt * (nt - 1)) / 2)));
      stan::math::fill(Cnst_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 8;
      assign(Cnst_free__, nil_index_list(),
        stan::math::cov_matrix_free(Cnst), "assigning variable Cnst_free__");
      std::vector<Eigen::Matrix<double, -1, -1>> H;
      H = std::vector<Eigen::Matrix<double, -1, -1>>(T, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(H, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> H_flat__;
        current_statement__ = 9;
        assign(H_flat__, nil_index_list(), context__.vals_r("H"),
          "assigning variable H_flat__");
        current_statement__ = 9;
        pos__ = 1;
        current_statement__ = 9;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 9;
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            current_statement__ = 9;
            for (int sym3__ = 1; sym3__ <= T; ++sym3__) {
              current_statement__ = 9;
              assign(H,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                H_flat__[(pos__ - 1)], "assigning variable H");
              current_statement__ = 9;
              pos__ = (pos__ + 1);}}}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> H_free__;
      H_free__ = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(
        (nt + ((nt * (nt - 1)) / 2))));
      stan::math::fill(H_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 9;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 9;
        assign(H_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::cov_matrix_free(H[(sym1__ - 1)]),
          "assigning variable H_free__");}
      std::vector<Eigen::Matrix<double, -1, -1>> rr;
      rr = std::vector<Eigen::Matrix<double, -1, -1>>(rr_1dim__, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(rr, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> rr_flat__;
        current_statement__ = 10;
        assign(rr_flat__, nil_index_list(), context__.vals_r("rr"),
          "assigning variable rr_flat__");
        current_statement__ = 10;
        pos__ = 1;
        current_statement__ = 10;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 10;
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            current_statement__ = 10;
            for (int sym3__ = 1; sym3__ <= rr_1dim__; ++sym3__) {
              current_statement__ = 10;
              assign(rr,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                rr_flat__[(pos__ - 1)], "assigning variable rr");
              current_statement__ = 10;
              pos__ = (pos__ + 1);}}}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> mu;
      mu = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(nt));
      stan::math::fill(mu, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> mu_flat__;
        current_statement__ = 11;
        assign(mu_flat__, nil_index_list(), context__.vals_r("mu"),
          "assigning variable mu_flat__");
        current_statement__ = 11;
        pos__ = 1;
        current_statement__ = 11;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 11;
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            current_statement__ = 11;
            assign(mu,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              mu_flat__[(pos__ - 1)], "assigning variable mu");
            current_statement__ = 11;
            pos__ = (pos__ + 1);}}
      }
      std::vector<Eigen::Matrix<double, -1, -1>> A;
      A = std::vector<Eigen::Matrix<double, -1, -1>>(Q, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(A, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> A_flat__;
        current_statement__ = 12;
        assign(A_flat__, nil_index_list(), context__.vals_r("A"),
          "assigning variable A_flat__");
        current_statement__ = 12;
        pos__ = 1;
        current_statement__ = 12;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 12;
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            current_statement__ = 12;
            for (int sym3__ = 1; sym3__ <= Q; ++sym3__) {
              current_statement__ = 12;
              assign(A,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                A_flat__[(pos__ - 1)], "assigning variable A");
              current_statement__ = 12;
              pos__ = (pos__ + 1);}}}
      }
      std::vector<Eigen::Matrix<double, -1, -1>> B;
      B = std::vector<Eigen::Matrix<double, -1, -1>>(P, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(B, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> B_flat__;
        current_statement__ = 13;
        assign(B_flat__, nil_index_list(), context__.vals_r("B"),
          "assigning variable B_flat__");
        current_statement__ = 13;
        pos__ = 1;
        current_statement__ = 13;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 13;
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            current_statement__ = 13;
            for (int sym3__ = 1; sym3__ <= P; ++sym3__) {
              current_statement__ = 13;
              assign(B,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                B_flat__[(pos__ - 1)], "assigning variable B");
              current_statement__ = 13;
              pos__ = (pos__ + 1);}}}
      }
      std::vector<Eigen::Matrix<double, -1, -1>> corH;
      corH = std::vector<Eigen::Matrix<double, -1, -1>>(T, Eigen::Matrix<double, -1, -1>(nt, nt));
      stan::math::fill(corH, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> corH_flat__;
        current_statement__ = 14;
        assign(corH_flat__, nil_index_list(), context__.vals_r("corH"),
          "assigning variable corH_flat__");
        current_statement__ = 14;
        pos__ = 1;
        current_statement__ = 14;
        for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
          current_statement__ = 14;
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            current_statement__ = 14;
            for (int sym3__ = 1; sym3__ <= T; ++sym3__) {
              current_statement__ = 14;
              assign(corH,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                corH_flat__[(pos__ - 1)], "assigning variable corH");
              current_statement__ = 14;
              pos__ = (pos__ + 1);}}}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> corH_free__;
      corH_free__ = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(
        ((nt * (nt - 1)) / 2)));
      stan::math::fill(corH_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 14;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 14;
        assign(corH_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::corr_matrix_free(corH[(sym1__ - 1)]),
          "assigning variable corH_free__");}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(phi0[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(
            rvalue(phi_free__,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              "phi_free__"));}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(
            rvalue(theta_free__,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              "theta_free__"));}}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(beta0[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        vars__.emplace_back(beta1[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= ((nt * (nt - 1)) / 2); ++sym1__) {
        vars__.emplace_back(C_R_free__[(sym1__ - 1)]);}
      vars__.emplace_back(nu_free__);
      for (int sym1__ = 1; sym1__ <= (nt + ((nt * (nt - 1)) / 2)); ++sym1__) {
        vars__.emplace_back(Cnst_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= (nt + ((nt * (nt - 1)) / 2)); ++sym2__) {
          vars__.emplace_back(H_free__[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= rr_1dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= nt; ++sym3__) {
            vars__.emplace_back(
              rvalue(rr,
                cons_list(index_uni(sym1__),
                  cons_list(index_uni(sym3__),
                    cons_list(index_uni(sym2__), nil_index_list()))), "rr"));
          }}}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          vars__.emplace_back(mu[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= Q; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= nt; ++sym3__) {
            vars__.emplace_back(
              rvalue(A,
                cons_list(index_uni(sym1__),
                  cons_list(index_uni(sym3__),
                    cons_list(index_uni(sym2__), nil_index_list()))), "A"));}
        }}
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= nt; ++sym3__) {
            vars__.emplace_back(
              rvalue(B,
                cons_list(index_uni(sym1__),
                  cons_list(index_uni(sym3__),
                    cons_list(index_uni(sym2__), nil_index_list()))), "B"));}
        }}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= ((nt * (nt - 1)) / 2); ++sym2__) {
          vars__.emplace_back(corH_free__[(sym1__ - 1)][(sym2__ - 1)]);}}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("phi0");
    names__.emplace_back("phi");
    names__.emplace_back("theta");
    names__.emplace_back("beta0");
    names__.emplace_back("beta1");
    names__.emplace_back("C_R");
    names__.emplace_back("nu");
    names__.emplace_back("Cnst");
    names__.emplace_back("H");
    names__.emplace_back("rr");
    names__.emplace_back("mu");
    names__.emplace_back("A");
    names__.emplace_back("B");
    names__.emplace_back("corH");
    names__.emplace_back("rts_p");
    names__.emplace_back("rts_forecasted");
    names__.emplace_back("H_p");
    names__.emplace_back("R_p");
    names__.emplace_back("H_forecasted");
    names__.emplace_back("R_forecasted");
    names__.emplace_back("rr_p");
    names__.emplace_back("mu_p");
    names__.emplace_back("mu_forecasted");
    names__.emplace_back("beta");
    names__.emplace_back("log_lik");
    names__.emplace_back("A_part_p");
    names__.emplace_back("B_part_p");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T),
                                             static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(rr_1dim__),
                                             static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(Q),
                                             static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(P),
                                             static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T),
                                             static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(rts_p_1dim__)
                                             , static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(ahead),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(H_p_1dim__),
                                             static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(R_p_1dim__),
                                             static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(ahead),
                                             static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(ahead),
                                             static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(rr_p_1dim__)
                                             , static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(mu_p_1dim__)
                                             , static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(ahead),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(beta_1dim__)
                                             , static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(log_lik_1dim__)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nt),
                                             static_cast<size_t>(nt)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "phi0" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "phi" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "theta" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta0" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta1" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "C_R" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    param_names__.emplace_back(std::string() + "nu");
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "Cnst" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= T; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "H" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= rr_1dim__; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "rr" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= Q; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "A" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= P; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "B" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= T; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "corH" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    if (emit_transformed_parameters__) {
      
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= rts_p_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "rts_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= ahead; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "rts_forecasted" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= H_p_1dim__; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "H_p" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= R_p_1dim__; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "R_p" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= ahead; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "H_forecasted" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= ahead; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "R_forecasted" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= rr_p_1dim__; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "rr_p" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= mu_p_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "mu_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= ahead; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "mu_forecasted" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= beta_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= log_lik_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "A_part_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "B_part_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "phi0" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "phi" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "theta" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta0" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta1" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= ((nt * (nt - 1)) / 2); ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "C_R" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "nu");
    for (int sym1__ = 1; sym1__ <= (nt + ((nt * (nt - 1)) / 2)); ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "Cnst" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= (nt + ((nt * (nt - 1)) / 2)); ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "H" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= rr_1dim__; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "rr" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= Q; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "A" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= P; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "B" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    for (int sym1__ = 1; sym1__ <= ((nt * (nt - 1)) / 2); ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "corH" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    if (emit_transformed_parameters__) {
      
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= rts_p_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "rts_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= ahead; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "rts_forecasted" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= (nt + ((nt * (nt - 1)) / 2)); ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= H_p_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "H_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= ((nt * (nt - 1)) / 2); ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= R_p_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "R_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= (nt + ((nt * (nt - 1)) / 2)); ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= ahead; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "H_forecasted" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= ((nt * (nt - 1)) / 2); ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= ahead; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "R_forecasted" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= rr_p_1dim__; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "rr_p" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= mu_p_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "mu_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= ahead; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "mu_forecasted" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= beta_1dim__; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= log_lik_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "A_part_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nt; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nt; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "B_part_p" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"phi0\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"beta0\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"beta1\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"C_R\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"nu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"Cnst\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"H\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"rr\",\"type\":{\"name\":\"array\",\"length\":" << rr_1dim__ << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"A\",\"type\":{\"name\":\"array\",\"length\":" << Q << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"B\",\"type\":{\"name\":\"array\",\"length\":" << P << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"corH\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"rts_p\",\"type\":{\"name\":\"array\",\"length\":" << rts_p_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"rts_forecasted\",\"type\":{\"name\":\"array\",\"length\":" << ahead << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"H_p\",\"type\":{\"name\":\"array\",\"length\":" << H_p_1dim__ << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"R_p\",\"type\":{\"name\":\"array\",\"length\":" << R_p_1dim__ << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"H_forecasted\",\"type\":{\"name\":\"array\",\"length\":" << ahead << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"R_forecasted\",\"type\":{\"name\":\"array\",\"length\":" << ahead << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"rr_p\",\"type\":{\"name\":\"array\",\"length\":" << rr_p_1dim__ << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"mu_p\",\"type\":{\"name\":\"array\",\"length\":" << mu_p_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"mu_forecasted\",\"type\":{\"name\":\"array\",\"length\":" << ahead << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"beta\",\"type\":{\"name\":\"matrix\",\"rows\":" << beta_1dim__ << ",\"cols\":" << nt << "},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"array\",\"length\":" << log_lik_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"A_part_p\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"generated_quantities\"},{\"name\":\"B_part_p\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"phi0\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"beta0\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"beta1\",\"type\":{\"name\":\"vector\",\"length\":" << nt << "},\"block\":\"parameters\"},{\"name\":\"C_R\",\"type\":{\"name\":\"vector\",\"length\":" << ((nt * (nt - 1)) / 2) << "},\"block\":\"parameters\"},{\"name\":\"nu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"Cnst\",\"type\":{\"name\":\"vector\",\"length\":" << (nt + ((nt * (nt - 1)) / 2)) << "},\"block\":\"parameters\"},{\"name\":\"H\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << (nt + ((nt * (nt - 1)) / 2)) << "}},\"block\":\"parameters\"},{\"name\":\"rr\",\"type\":{\"name\":\"array\",\"length\":" << rr_1dim__ << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"A\",\"type\":{\"name\":\"array\",\"length\":" << Q << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"B\",\"type\":{\"name\":\"array\",\"length\":" << P << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"parameters\"},{\"name\":\"corH\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << ((nt * (nt - 1)) / 2) << "}},\"block\":\"parameters\"},{\"name\":\"rts_p\",\"type\":{\"name\":\"array\",\"length\":" << rts_p_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"rts_forecasted\",\"type\":{\"name\":\"array\",\"length\":" << ahead << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"H_p\",\"type\":{\"name\":\"array\",\"length\":" << H_p_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << (nt + ((nt * (nt - 1)) / 2)) << "}},\"block\":\"generated_quantities\"},{\"name\":\"R_p\",\"type\":{\"name\":\"array\",\"length\":" << R_p_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << ((nt * (nt - 1)) / 2) << "}},\"block\":\"generated_quantities\"},{\"name\":\"H_forecasted\",\"type\":{\"name\":\"array\",\"length\":" << ahead << ",\"element_type\":{\"name\":\"vector\",\"length\":" << (nt + ((nt * (nt - 1)) / 2)) << "}},\"block\":\"generated_quantities\"},{\"name\":\"R_forecasted\",\"type\":{\"name\":\"array\",\"length\":" << ahead << ",\"element_type\":{\"name\":\"vector\",\"length\":" << ((nt * (nt - 1)) / 2) << "}},\"block\":\"generated_quantities\"},{\"name\":\"rr_p\",\"type\":{\"name\":\"array\",\"length\":" << rr_p_1dim__ << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"mu_p\",\"type\":{\"name\":\"array\",\"length\":" << mu_p_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"mu_forecasted\",\"type\":{\"name\":\"array\",\"length\":" << ahead << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nt << "}},\"block\":\"generated_quantities\"},{\"name\":\"beta\",\"type\":{\"name\":\"matrix\",\"rows\":" << beta_1dim__ << ",\"cols\":" << nt << "},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"array\",\"length\":" << log_lik_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"A_part_p\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"generated_quantities\"},{\"name\":\"B_part_p\",\"type\":{\"name\":\"matrix\",\"rows\":" << nt << ",\"cols\":" << nt << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_forecastBEKK_namespace::model_forecastBEKK;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_forecastBEKK_namespace::profiles__;
}
#endif
#endif
