% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_bayesplot.R
\name{bayesplot}
\alias{bayesplot}
\title{bayesian convergence diagnosis plotting function}
\usage{
bayesplot(x, pars, plot, inc_warmup = FALSE)
}
\arguments{
\item{x}{returned object}

\item{pars}{Names of plotted parameters. They can be "theta", "alpha", "delta", "tau", "cor", "lambda", or a subset of parameters. See vignette for bmggum for more details.}

\item{plot}{Types of plots.They can be "density", "trace", or "autocorrelation".}

\item{inc_warmup}{Whether to include warmup iterations or not when plotting. The default is FALSE.}
}
\value{
Selected plots for selected parameters
}
\description{
This function provides plots including density plots, trace plots, and auto-correlation plots to aid model convergence diagnosis.
}
\examples{
Data <- c(1,4,2,3)
Data <- matrix(Data,nrow = 2)
deli <- c(1,-1,2,1)
deli <- matrix(deli,nrow = 2)
ind <- c(1,2)
ind <- t(ind)
cova <- c(0.70, -1.25)
mod <- bmggum(GGUM.Data=Data,delindex=deli,trait=2,ind=ind,option=4,covariate=cova,iter=5,chains=1)
bayesplot(mod, 'alpha', 'density', inc_warmup=FALSE)
}
