% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mount.wl.bl.list.R
\name{mount.wl.bl.list}
\alias{mount.wl.bl.list}
\title{Mounts a white or black list}
\usage{
mount.wl.bl.list(black_or_white_list)
}
\arguments{
\item{black_or_white_list}{is a list of couple of variables.}
}
\value{
A new data frame with the 'from' and 'to' variables
}
\description{
This function receives a simple list with one or more couple of variables and mount a new data frame in "bnlearn" syntax.
The final result must return an object similar to the result of bnlearn command "data.frame(from = c('B', 'F'), to = c('F', 'B'))" that is more complex syntax.
}
\examples{
# Clean environment
closeAllConnections()
rm(list=ls())
# Set enviroment
# setwd("To your working directory")
# Load packages
library(bnpa)
library(bnlearn)
# Load data sets from package
data(dataQuantC)
# Show the first lines of data
head(dataQuantC)
# Learn the BN structure without black and white list
bn.structure <- hc(dataQuantC)
# Split graph panel in 2 columns
par(mfrow=c(1,2))
# Show the BN structure
bnlearn::graphviz.plot(bn.structure)
# Mounting the black list
black.list <- ("A-C,D-F")
black.list <- mount.wl.bl.list(black.list)
black.list
white.list <- ("A-B,D-G")
white.list <- mount.wl.bl.list(white.list)
white.list
# Learn the BN structure with black and white list
bn.structure <- hc(dataQuantC, whitelist = white.list, blacklist = black.list)
# Show the BN structure
bnlearn::graphviz.plot(bn.structure)
}
\references{
Scutari M (2017). Bayesian Network Constraint-Based Structure Learning Algorithms: Parallel and Optimized Implementations in the bnlearn R Package. Journal of Statistical Software, 77(2), 1-20.
}
\author{
Elias Carvalho
}
