% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_p_subpops_tree.R
\name{draw_p_subpops_tree}
\alias{draw_p_subpops_tree}
\title{Draw allele frequencies for subpopulations related by a tree}
\usage{
draw_p_subpops_tree(p_anc, tree_subpops, m_loci = NA, nodes = FALSE)
}
\arguments{
\item{p_anc}{The scalar or length-\code{m_loci} vector of ancestral allele frequencies per locus.}

\item{tree_subpops}{The coancestry tree relating the \code{k_subpops} subpopulations.
Must be a \code{phylo} object from the \code{ape} package (see \code{\link[ape:read.tree]{ape::read.tree()}}).
The edge lengths of this tree must be the FST parameters relating parent and child subpopulations.}

\item{m_loci}{If \code{p_anc} is scalar, optionally provide the desired number of loci (lest only one locus be simulated).
Stops if both \code{length(p_anc) > 1} and \code{m_loci} is not \code{NA} and they disagree.}

\item{nodes}{If \code{FALSE} (default), returns allele frequencies of "tip" subpopulations only; otherwise returns all allele frequencies, including internal nodes.}
}
\value{
The \code{m_loci}-by-\code{k_subpops} matrix of independent subpopulation allele frequencies.
If \code{nodes = FALSE}, columns include only tip subpopulations.
If \code{nodes = TRUE}, internal node subpopulations are also included (in this case the input \code{p_anc} is returned in the column corresponding to the root node).
In all cases subpopulations are ordered as indexes in the tree, which normally implies the tip nodes are listed first, followed by the internal nodes (as in \code{tree_subpops$edge} matrix, see \code{\link[ape:read.tree]{ape::read.tree()}} for details).
The \code{tree_subpops} tip and node names are copied to the column names of this output matrix (individual names may be blank if missing in tree (such as for internal nodes); column names are \code{NULL} if all \code{tree_subpops} tip labels were blank, regardless of internal node labels).
If \code{p_anc} is length-\code{m_loci} with names, these names are copied to the row names of this output matrix.
}
\description{
The allele frequency matrix \code{P} for \code{m_loci} loci (rows) and \code{k_subpops} subpopulations (columns) are drawn from the Balding-Nichols distribution.
If the allele frequency in the parent node is \code{p} and the FST parameter of the child node from the parent node is \code{F}, then the allele frequency in the child node is drawn from
\code{rbeta( 1, nu * p, nu * ( 1 - p ) )},
where \code{nu <- 1 / F - 1}.
This function iterates drawing allele frequencies through the tree structure, therefore allowing covariance between subpopulations that share branches.
}
\examples{
# for simulating a tree with `rtree`
library(ape)

# a typical, non-trivial example
# number of tip subpopulations
k_subpops <- 3
# number of loci
m_loci <- 10
# random vector of ancestral allele frequencies
p_anc <- draw_p_anc(m_loci)
# simulate tree
tree_subpops <- rtree( k_subpops )
# matrix of intermediate subpop allele freqs
p_subpops <- draw_p_subpops_tree(p_anc, tree_subpops)

}
\seealso{
\code{\link[=draw_p_subpops]{draw_p_subpops()}} for version for independent subpopulations.

For "phylo" tree class, see \code{\link[ape:read.tree]{ape::read.tree()}}
}
