% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_tree.R
\name{fit_tree}
\alias{fit_tree}
\title{Fit a tree structure to a coancestry matrix}
\usage{
fit_tree(coancestry, method = "mcquitty")
}
\arguments{
\item{coancestry}{The coancestry matrix to fit a tree to.}

\item{method}{The hierarchical clustering method (passed to \code{\link[stats:hclust]{stats::hclust()}}).
While all \code{\link[stats:hclust]{stats::hclust()}} methods are supported, only two really make sense for this application: "mcquitty" (i.e. WPGMA, default) and "average" (UPGMA).}
}
\value{
A \code{phylo} object from the \code{ape} package (see \code{\link[ape:read.tree]{ape::read.tree()}}), with two additional list elements at the end:
\itemize{
\item \code{edge}: (standard \code{phylo}.)  A matrix describing the tree topology, listing parent and child node indexes.
\item \code{Nnode}: (standard \code{phylo}.)  Number of internal (non-leaf) nodes.
\item \code{tip.label}: (standard \code{phylo}.)  Labels for tips (leaf nodes), in order of index as in \code{edge} matrix above.
These match the row names of the input \code{coancestry} matrix, or if names are missing, the row indexes of this matrix are used (in both cases, labels may be reordered compared to \code{rownames( coancestry )}).
Tips are ordered as they appear in the above \code{edge} matrix (ensuring visual agreement in plots between the tree and its resulting coancestry matrix via \code{\link[=coanc_tree]{coanc_tree()}}), and in an order that matches the input \code{coancestry}'s subpopulation order as much as possible (tree constraints do not permit arbitrary tip orders, but a heuristic implemented in \code{\link[=tree_reorder]{tree_reorder()}} is used to determine a reasonable order when an exact match is not possible).
\item \code{edge.length}: (standard \code{phylo}.)  Values of edge lengths in same order as rows of \code{edge} matrix above.
\item \code{root.edge}: (standard \code{phylo}.)  Value of root edge length.
\item \code{rss}:  The residual sum of squares of the model coancestry versus the input coancestry.
\item \code{edge.length.add}: Additive edge values (regarding their effect on coancestry, as opposed to \code{edge.length} which are probabilities, see \code{\link[=coanc_tree]{coanc_tree()}})
}
}
\description{
Implements a heuristic algorithm to find the optimal tree topology based on joining pairs of subpopulations with the highest between-coancestry values, and averaging parent coancestries for the merged nodes (a variant of WPGMA hierarchical clustering \code{\link[stats:hclust]{stats::hclust()}}).
Branch lengths are optimized using the non-negative least squares approach \code{\link[nnls:nnls]{nnls::nnls()}}, which minimize the residual square error between the given coancestry matrix and the model coancestry implied by the tree.
This algorithm recovers the true tree when the input coancestry truly belongs to this tree and there is no estimation error (i.e. it is the inverse function of \code{\link[=coanc_tree]{coanc_tree()}}), and performs well for coancestry estimates (i.e. the result of simulating genotypes from the true tree, i.e. from \code{\link[=draw_all_admix]{draw_all_admix()}}, and estimating the coancestry using \code{\link[popkin:popkin]{popkin::popkin()}} followed by \code{\link[popkin:inbr_diag]{popkin::inbr_diag()}}).
}
\details{
The tree is bifurcating by construction, but edges may equal zero if needed, effectively resulting in multifurcation, although this code makes no attempt to merge nodes with zero edges.
For best fit to arbitrary data, the root edge is always fit to the data (may also be zero).
Data fit may be poor if the coancestry does not correspond to a tree, particularly if there is admixture between subpopulations.
}
\examples{
# create a random tree
library(ape)
k <- 5
tree <- rtree( k )
# true coancestry matrix for this tree
coanc <- coanc_tree( tree )

# now recover tree from this coancestry matrix:
tree2 <- fit_tree( coanc )
# tree2 equals tree!

}
\seealso{
\code{\link[=coanc_tree]{coanc_tree()}}) for the inverse function (when the coancestry corresponds exactly to a tree).

\code{\link[=tree_reorder]{tree_reorder()}} for reordering tree structure so that tips appear in a particular desired order.
}
