% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/26_computingDiscMarginFRN.R
\name{discMarginFRN}
\alias{discMarginFRN}
\title{Calculates Discount Margin of a Floating-Rate Note (FRN).}
\usage{
discMarginFRN(index, estRtrn, mvFRN, priceFRN, maturityYears, periodicity)
}
\arguments{
\item{index}{A number.}

\item{estRtrn}{A number.}

\item{mvFRN}{A number.}

\item{priceFRN}{A number.}

\item{maturityYears}{A number.}

\item{periodicity}{A number.}
}
\value{
Input values to six arguments  \code{index} ,\code{estRtrn}, \code{mvFRN}, \code{priceFRN}, \code{maturityYears}, and  \code{periodicity}.
}
\description{
Calculates Discount Margin of a Floating-Rate Note (FRN).
}
\details{
According to information provided by Adams and Smith (2019), the method \code{discMarginFRN()} is developed to compute Discount Margin of a Floating-Rate Note (FRN) for the values passed to its six arguments. Here, \code{index} is reference rate, stated as an annual percentage rate,\code{estRtrn} is a vector of estimated returns on FRN (this does not include repayment of the principal), \code{mvFRN} represents Maturity Value, \code{priceFRN} price of FRN, \code{maturityYears} is number of years to Maturity, and \code{periodicity} is periodicity of interest payments. The given examples show various ways in which the arguments can be passed to \code{discMarginFRN()}.
}
\examples{
discMarginFRN(index=0.0200,estRtrn=0.8125,mvFRN=100,priceFRN=98,maturityYears=4,periodicity=4)
discMarginFRN(0.0200,0.8125, 100, 98, 4, 4)
}
\references{
Adams,J.F. & Smith,D.J.(2019). Introduction to fixed-income valuation. In CFA Program Curriculum 2020 Level I Volumes 1-6. (Vol. 5, pp. 107-151). Wiley Professional Development (P&T). ISBN 9781119593577, \url{https://bookshelf.vitalsource.com/books/9781119593577}
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
