% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trt_horseshoe.R
\name{trt_horseshoe}
\alias{trt_horseshoe}
\title{Subgroup Treatment Effect Horseshoe}
\usage{
trt_horseshoe(object, gamma = 1, l = NULL, m = 50)
}
\arguments{
\item{object}{(\code{horseshoe})\cr the horseshoe object.}

\item{gamma}{(\code{scalar})\cr numeric value defining the weights to obtain
the average hazard ratio. Default is 1 (in this case the average hazard
ratio obtained can be interpreted as the odds of concordance). Just needed
when using survival data.}

\item{l}{(\code{scalar})\cr the maximum value of time that wants to be studied to
obtain the average hazard ratio. Default is the maximum value of time when
there was an event. Just needed when using survival data.}

\item{m}{(\code{scalar})\cr the value that defines the equally spaced time points
where the survival curves are going to be studied. Default is 50. Just needed
when using survival data.}
}
\value{
Approximated posterior distribution of the subgroup treatment effects.
}
\description{
Function to obtain the estimated posterior distribution of the subgroup
treatment effects considering a horseshoe fitted model.
}
\examples{
trt_horseshoe(horseshoe_fit_surv, m = 1)
}
