% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aidedboot.R
\name{aidedboot}
\alias{aidedboot}
\title{Aided Frequency Bootstrap}
\usage{
aidedboot(x, XI, g, B, order = NULL, kernel = "normal", bandwidth)
}
\arguments{
\item{x}{A numeric vector representing a time series.}

\item{XI}{A list of functions defined on the interval \eqn{[0, \pi]}.}

\item{g}{A numeric function taking \code{length(XI)} as arguments.}

\item{B}{A positive integer; the number of bootstrap samples.}

\item{order}{The order of the autoregressive sieve process (integer).
If not specified, it is set by default as
\deqn{\left \lfloor  4 * (length(x) \log(length(x)))^{1/4}\right \rfloor.}}

\item{kernel}{A character string specifying the smoothing kernel. The possible choices are:
\code{"normal"}, \code{"box"} and \code{"epanechnikov"}.}

\item{bandwidth}{The kernel bandwidth smoothing parameter. If missing, the bandwidth
is automaticly computed by \code{\link{bandw1}}.}
}
\value{
\code{aidedboot} returns an object of class \code{boodd}
(see \link{class.boodd}).
}
\description{
The Aided Frequency Bootstrap (AFB) is a variation of the Frequency
Domain Bootstrap (FDB). The idea is to fit a sieve AR(p) model and to generate
the corresponding bootstrapped time series (by resampling centered residuals) with
periodogram \eqn{I^{\ast}_{AR}}.
Then the we estimate the quotient of the two
spectral densities \eqn{q(\omega)=\frac{f(\omega)}{f_{AR}(\omega)}} and generate
bootstrap periodogram by multiplying \eqn{I^{\ast}_{AR}} by this quantity
\eqn{q(\omega)=\frac{f(\omega)}{f_{AR}(\omega)}}.
}
\details{
The idea underlying the Aided Frequency Bootstrap is
importance sampling. It was introduced by Kreiss and Paparoditis (2003) and
allows to better mimic the asymptotic covariance structure of the
periodogram in the bootstrap world. Kreiss and Paparoditis (2003)
considered a spectral density which is easy to estimate (typically based on
a sieve AR representation of the time series), say \eqn{f_{AR}(\omega)}.
The argument \code{x} is supposed to be a sample of a real valued zero-mean
stationary time series.

The autoregressive sieve process of order \eqn{l=l(n)} is modelled as
\deqn{X_{t}=\sum_{k=1}^{l}\psi_{k}X_{t-k}+\epsilon_{t}}
with \eqn{E(\epsilon_{t})=0, Var(\epsilon_{t})=\sigma^{2}(l)}.

We estimate functionals of the spectral density \eqn{T(f)} of the form
\deqn{
 T(f)=g(A(\xi,f))
}
where \eqn{g} is a third order differentiable function,
\deqn{A(\xi,f)=\left(  \int_{0}^{\pi}\xi_{1}(\omega)f(\omega)d\omega,\int_{0}^{\pi
}\xi_{2}(\omega)f(\omega)d\omega,\dots,\int_{0}^{\pi}\xi_{p}(\omega
)f(\omega)d\omega\right)
}
and
\deqn{
 \xi=(\xi_{1},\dots,\xi_{p}): [0,\pi] \rightarrow R^p.
}

If the \code{order} argument is not specified, its default value is
\eqn{l=\left \lfloor  (4*(n\log(n))^{1/4})\right \rfloor}, where \code{n} is the length of \code{x}.

The \code{kernel} argument has the same meaning as in the \code{\link{freqboot}}
function.
}
\examples{
n <- 200
x <- arima.sim(list(order=c(4,0,0),ar=c(0.7,0.4,-0.3,-0.1)),n=n)
B <- 299
one <- function(x) {1}
XI <- list(cos,one)
g <- function(x,y) {return(x/y)}
ord <- 2*floor(n^(1/3))
boo <- aidedboot(x,XI,g,B,order=ord) 
plot(boo)
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek)- submitted.

Kreiss, J.-P. and Paparoditis, E. (2003). Autoregressive aided
periodogram bootstrap for time series. \emph{Ann. Stat.} \bold{31} 1923--1955.
}
\seealso{
\code{\link{freqboot}}.
}
\keyword{"Frequency}
\keyword{Bootstrap}
\keyword{Periodogram}
\keyword{domain"}
