% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_wild.R
\name{boot_wild}
\alias{boot_wild}
\title{TFT wild bootstrap.}
\usage{
boot_wild(X, n = length(X), h, kernel, t)
}
\arguments{
\item{X}{A numeric vector representing a time series.}

\item{n}{An integer; by default is the length of time series \code{X} but allow for a
smaller sample size m to perform moon bootstrap.}

\item{h}{A positive numeric value specifying the bandwidth used to compute the kernel estimator
in case of local bootstrap.
By default it is equal to \eqn{n^{-2/3}}.}

\item{kernel}{An integer value indicating the kernel type. Use \code{0}
for the Daniell kernel or any other value for the Bartlett-Priestley (Epanechnikov) kernel
(by default).}

\item{t}{An integer indicating the number of bootstrap replications.}
}
\value{
A matrix where each column contains a bootstrap replicate of the time series \code{X}.
}
\description{
The wild bootstrap is used to bootstrap the Fourier coefficients for
the Time Frequency Toggle (TFT)-Bootstrap (see Kirch and Politis (2011)).
}
\details{
The function centers process \code{X} by subtracting its mean,
then computes the Fourier coefficients using
the Fast Fourier Transform (FFT). These coefficients are used to compute periodograms, which
are then smoothed using a spectral density estimation method based on the chosen
kernel \code{kernel} and bandwidth \code{h}.
Random normal samples are scaled by these smoothed spectral densities to generate
bootstrapped replicates.
}
\examples{
# see the mother function tft_boot
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Kirch, C. and Politis, D. N. (2011). TFT-Bootstrap: Resampling time series in the frequency
domain to obtain replicates in the time domain, \emph{Annals of Statistics}, vol.
}
\seealso{
\code{\link{tft_boot}}, \code{\link{boot_res}},
\code{\link{boot_local}}.
}
\author{
We are grateful to Claudia Kirch for providing the original code in \code{R}.
}
\keyword{"Fast}
\keyword{"Frequency}
\keyword{Bootstrap}
\keyword{Fourier}
\keyword{Transform"}
\keyword{and}
\keyword{domain"}
\keyword{time}
