% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findParameter.R
\name{findChi2ncp}
\alias{findChi2ncp}
\title{Find non-centrality parameter}
\usage{
findChi2ncp(df, q, p)
}
\arguments{
\item{df}{degrees of freedom, a positive number}

\item{q}{a quantile}

\item{p}{probability corresponding to the quantile \code{q}}
}
\value{
The non-centrality parameter of the Chi-squared distribution with
  degrees of freedom parameter \code{df} and with cumulative probability
  \code{p} at the quantile \code{q}.
}
\description{
Find the non-centrality parameter of a Chi-squared distribution
  given a quantile, its corresponding probability, and the degrees of freedom.
}
\examples{
library(boodist)
ncp <- findChi2ncp(df = 1, q = 3, p = 0.1)
pchisq(3, df = 1, ncp = ncp) # should be 0.1
}
