% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PPBMT.R
\name{PPBMT}
\alias{PPBMT}
\title{Pairwise Parametric Bootstrap Mean Test (PPBMT)}
\usage{
PPBMT(means, vars, ns, B = 1000, alpha = 0.05)
}
\arguments{
\item{means}{A numeric vector containing the sample means for each group.}

\item{vars}{A numeric vector containing the sample variances for each group.}

\item{ns}{An integer vector indicating the sample sizes of each group.}

\item{B}{Number of bootstrap re-samples. Default is 1000.}

\item{alpha}{Significance level for the hypothesis test. Default is 0.05.}
}
\value{
A list of class \code{"PPBMT"} containing:
\item{test_statistic}{Observed value of the test statistic.}
\item{critical_value}{Bootstrap-based critical value.}
\item{decision}{Conclusion of the hypothesis test.}
}
\description{
Performs a parametric bootstrap test to compare all pairwise group means
under heteroscedasticity, assuming normality of the data.
}
\examples{
# Example with 3 groups
set.seed(123)
g1 <- rnorm(20, mean = 5, sd = 1.5)
g2 <- rnorm(25, mean = 6.5, sd = 2)
g3 <- rnorm(22, mean = 7.2, sd = 2.5)

means <- c(mean(g1), mean(g2), mean(g3))
vars <- c(var(g1), var(g2), var(g3))
ns <- c(length(g1), length(g2), length(g3))

result <- PPBMT(means, vars, ns, B = 1000, alpha = 0.05)
print(result)

}
