% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pate.R
\name{pate}
\alias{pate}
\title{Population Average Treatment Effect (PATE)}
\usage{
pate(
  formula,
  estimator = c("BART", "bayesian_lm"),
  data,
  src_var,
  primary_source,
  exch_prob,
  trt_var,
  compliance_var,
  ndpost = 1000,
  model_prior = c("none", "power", "powerlog"),
  ...
)
}
\arguments{
\item{formula}{An object of class formula. The left hand side must be the outcome,
and the right hand side must include the treatment variable. To adjust for confounding,
the right hand side must also include the confounders. For the Bayesian linear model,
the use is responsible for specifying the function form.}

\item{estimator}{"bayesian_lm" or "BART". If "bayesian_lm", a Bayesian linear model with
a normal inverse-gamma prior. If "BART", Bayesian Additive Regression Trees}

\item{data}{the data frame with the outcome variable and all variables in the formula}

\item{src_var}{a character variable which variable indicates the source variable.
Must match a column name in the data.}

\item{primary_source}{character variable indicating the primary source. Must match
one of the values of \code{src_var}.}

\item{exch_prob}{numeric vector giving prior probability that each source is exchangeable
with the primary source. Number of elements must be equal to the number of sources
minus 1. Each element must be between 0 and 1.
Order of probabilities should match the order returned by calling \code{levels(factor(...))}
on the source vector. See the vignette for an example of usage.}

\item{trt_var}{which variable indicates the treatment.
Must match a column name in the data. Must be coded as numeric values 0 and 1, 0 for
untreated, 1 for treated.}

\item{compliance_var}{Optional argument if adjustment for confounding
due to noncompliance is needed. \code{compliance_var} indicates the compliance
indicator.
Must match a column name in the data. Must be coded as numeric values 0 and 1, 0 for
noncompliant, 1 for compliant. If this argument is specified, the formula must also
include the compliance variable.}

\item{ndpost}{number of draws from the posterior}

\item{model_prior}{specifices the prior probability of exchangebility of data sources. Details for priors
are given in Boatman et al. (2020).}

\item{...}{additional arguments passed to BART}
}
\value{
A list with components:

\item{call}{The function call}

\item{estimator}{The estimator used to adjust for confounding, "bayesian_lm" for
Bayesian linear model, or "BART" for Bayesian additive regression trees}

\item{EY0}{Posterior draws of the expected potential outcome if all observations were
treated. One column for each MEM}

\item{EY1}{Posterior draws of the expected potential outcome if all observations were
untreated. One column for each MEM}

\item{log_marg_like}{Log marginal likelihood for each MEM}

\item{mem_pate_post}{Array containing, for each MEM, posterior draws for the population
average treatment effect}

\item{MEMs}{Matrix showing showing which data sources are exchangeable under each MEM.
1 = exchangeable.}

\item{pate_post}{Posterior draws for the population average treatment effect. Weighted
average of \code{mem_pate_post}, where \code{post_probs} are the weights}

\item{post_probs}{Posterior probability that each MEM (shown in the list element \code{MEMs})
is the true model.}

\item{exch_prob}{Prior probability that each source is exchangeable with the primary source.}

\item{beta_post_mean}{If \code{estimator = "bayesian_lm"}, a matrix with the posterior means
of the coefficients for the primary source from each MEM. If \code{estimator = "BART"}, \code{NA}}.

\item{beta_post_var}{If \code{estimator} = \code{"bayesian_lm"}, a matrix with the posterior variance
of the coefficients for the primary source from each MEM. If \code{estimator = "BART"}, \code{NA}}.

\item{beta_post_var}{If \code{estimator = "bayesian_lm"}, a matrix with the posterior variance
of the coefficients for the primary source from each MEM. If \code{estimator = "BART"}, \code{NA}}.

\item{non_compliance}{Logical, indicating whether the model adjusted for confounding
due to noncompliance}
}
\description{
Estimates the population average treatment effect from a primary data source
with potential borrowing from supplemental sources. Adjust for confounding by fitting
a conditional mean model with the treatment variable and confounding variables.
}
\details{
To adjust for confounding, the PATE is estimated using a
model for the conditional mean given treatment and confounders. Currently,
two models are available, a Bayesian linear model with an inverse-gamma prior,
and Bayesian Additive Regression Trees (BART; Chipman & McCulloch, 2010).
The user must specify a
formula for the conditional mean. This requires more thought for the
Bayesian linear model as the analyst must carefully consider the functional
form of the regression relationship. For BART, the right hand side of the
formula need only include the confounders and the treatment variable without
specification of the functional form. If there is no confounding, the right hand
side of the formula needs to include the treatment variable only.

If \code{formula = "bayesian_lm"}, then the function fits the Bayesian linear model
\deqn{Y = X\beta + \epsilon, \epsilon ~ N(0, \sigma ^ 2).}
The prior on the regression coefficients is normal with mean vector 0 and variance
matrix with diagonal elements equal to 100 and off-diagonal elements equal to 0.
The prior on \eqn{\sigma ^ 2} is a Inverse Gamma(0.1, 0.1)

If \code{formula = "BART"}, the function fits the Bayesian Additive Regression Trees
model, but with a modified prior on the terminal nodes. The prior on each terminal node
is
\deqn{N(0, \gamma\sigma ^ 2).} The package uses the default value
\deqn{\gamma = 1 / (16 * m * \hat{sigma ^ 2})} where \eqn{m} is the number of trees and \eqn{\hat{sigma ^ 2}} is the variance of \eqn{Y}.

Borrowing between data sources is done with
Multisource Exchangeability Models
(MEMs; Kaizer et al., 2018) . MEMs borrow by assuming that each supplementary data source
is either "exchangeable", or not, with the primary data source. Two data sources
are considered exchangeable if their model parameters are equal. Each data source
can be exchangeable with the primary data, or not, so if there are \eqn{r} data
sources, there are \eqn{2 ^ r} possible configurations regarding the exchangeability
assumptions. Each of these configurations corresponds to a single MEM.
The parameters for each MEM are estimated, and we compute a posterior probability
for each. The posterior density of the PATE is a weighted posterior across all
possible MEMs.
}
\examples{
data(adapt)

est <- pate(y ~ treatment*x + treatment*I(x ^ 2), data = adapt,
 estimator = "bayesian_lm", src_var = "source", primary_source = "Primary",
 trt_var = "treatment")

summary(est)

}
\references{
Chipman, H. & McCulloch, R. (2010) BART: Bayesian additive regression trees. Annals
of Applied Statistics, 4(1): 266-298.

Kaizer, Alexander M., Koopmeiners, Joseph S., Hobbs, Brian P. (2018) Bayesian
hierarchical modeling based on multisource exchangeability. Biostatistics,
19(2): 169-184.

Boatman, Jeffrey A., Vock, David. M, and Koopmeiners, Joseph S. (2020) Borrowing from
Supplemental Sources to Estimate Causal Effects from a Primary Data Source. arXiv:2003.09680
}
