% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxcoxtype.R
\name{boxcoxtype}
\alias{boxcoxtype}
\alias{boxcoxpower}
\alias{binomial}
\title{Box-Cox-type link function for logistic mixed-effects Models}
\usage{
boxcoxtype(
  formula,
  random = ~1,
  k = 3,
  trials = 1,
  data,
  find.in.range = c(-2, 2),
  s = 20,
  plot.opt = 1,
  random.distribution = "np",
  ...
)

boxcoxpower(Lambda = 0)

binomial(link = boxcoxpower(0))
}
\arguments{
\item{formula}{a formula describing the transformed response and the fixed
effect model (e.g. y ~ x).}

\item{random}{a formula defining the random model. Set \code{random= ~1} to model
logistic-type overdispersion model. For a two-level logistic-type model,
set \code{random= ~1|groups}, where groups are at the upper level.}

\item{k}{the number of mass points.}

\item{trials}{optional prior weights for the data. For Bernoulli distribution, set trials=1.}

\item{data}{a data frame containing variables used in the fixed and random
effect models.}

\item{find.in.range}{search in a range of \code{Lambda}, with default (-2,2)
in step of 0.1.}

\item{s}{number of points in the grid search of \code{Lambda}.}

\item{plot.opt}{Set \code{plot.opt=1}, to plot the profile log-likelihood against \code{Lambda}.
if \code{plot.opt=0}, no plot is printed.}

\item{random.distribution}{the mixing distribution, Gaussian Quadrature (gq) or NPML (np) can be set.}

\item{\dots}{extra arguments will be ignored.}

\item{Lambda}{the power of the transformation}

\item{link}{the link function to be used.}
}
\value{
List with class \code{boxcoxmix} containing:
\item{Maximum}{the best estimate of \code{Lambda} found.} \item{objective}{the value of the profile
log-likelihood corresponding to Maximum.} 
\item{coef}{the vector of coefficients.} 
\item{profile.loglik}{the profile log-likelihood of the fitted regression model.}
\item{fit}{the fitted alldist object from the last EM iteration.}
\item{aic}{the Akaike information criterion of the fitted regression model.} 
\item{bic}{the Bayesian information criterion of the fitted regression model.}

The other outcomes are not relevant to users and they are intended for internal use only.
}
\description{
The \code{boxcoxtype()} performs a grid search over the parameter \code{Lambda}
for logistic mixed-effects models and then optimizes over this grid,
to calculate the maximum likelihood estimator of the transformation.
}
\details{
The Box-Cox transformation (Box & Cox, 1964) is applied to the
logistic mixed-effects models with an unspecified
mixing distribution. The NPML estimate of the mixing distribution is known
to be a discrete distribution involving a finite number of mass-points and corresponding
masses (Aitkin et al., 2009). An Expectation-Maximization (EM) algorithm is
used for fitting the finite mixture distribution, one needs to specify the
number of components \code{k} of the finite mixture in advance.
This algorithm can be implemented using the npmlreg function \code{\link[npmlreg]{alldist}}
for the logistic-type overdispersion model and the npmlreg function \code{\link[npmlreg]{allvc}} for the 
two-level logistic-type model, setting \code{family = binomial(link = boxcoxpower(Lambda))} where 
\code{Lambda} is the value of the power transformation. When \code{k}=1, the npmlreg function \code{alldist()} 
fits the logistic regression model without random effects. 
 


\code{boxcoxtype()} performs a grid search over the parameter \code{Lambda} and then
optimizes over this grid, to calculate the maximum likelihood estimator of the transformation.
It produces a plot of the profile likelihood function that summarises information
concerning \code{Lambda}, including a vertical line indicating the best value of \code{Lambda}
that maximizes the profile log-likelihood.
}
\examples{
#Beta blockers data
data("betablocker", package = "flexmix")
library(npmlreg)
betavc <-allvc(cbind(Deaths, Total - Deaths) ~ Treatment, data = betablocker,random=~1|Center,
 k=3,random.distribution='np',family = binomial(link = boxcoxpower(0)))
betavc$disparity
#[1] 318.7211
betavc3 <-boxcoxtype(cbind(Deaths, Total - Deaths) ~ Treatment,random=~1|Center, 
data = betablocker, find.in.range = c(-2,0.4),s=40,k=3,random.distribution='np')
#Maximum Profile Log-likelihood: -158.6025 at lambda= -0.56
betavc3$fit$disparity
#[1] 317.2049
betavc3$aic
#[1] 331.2049
betavc3$bic
#[1] 343.6942

}
\references{
Box G. and Cox D. (1964). An analysis of transformations. Journal of
the Royal Statistical Society. Series B (Methodological), pages 211-252.

Aitkin, M. A., Francis, B., Hinde, J., and Darnell, R. (2009). Statistical
modelling in R. Oxford University Press Oxford.

Jochen Einbeck, Ross Darnell and John Hinde (2014). npmlreg:
Nonparametric maximum likelihood estimation for random effect
models. R package version 0.46-1.
}
\seealso{
\code{\link{np.boxcoxmix}}, \code{\link{optim.boxcox}},
\code{\link{tolfind.boxcox}}, \code{\link{Kfind.boxcox}}.
}
\author{
Amani Almohaimeed and Jochen Einbeck
}
\keyword{boxcoxtype}
