% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc-Relative_RPKM.R
\name{BridgeRDataSetFromRaw}
\alias{BridgeRDataSetFromRaw}
\title{Calculate relative RPKM expression from raw data.}
\usage{
BridgeRDataSetFromRaw(inputFile, group = c("Control", "Knockdown"),
  hour = c(0, 1, 2, 4, 8, 12), cutoff = 0.1, cutoffBelow = 0.1,
  inforColumn = 4, save = T, outputPrefix = "BridgeR_1")
}
\arguments{
\item{inputFile}{The vector of tab-delimited matrix file.}

\item{group}{The vector of group names.}

\item{hour}{The vector of time course about BRIC-seq experiment.}

\item{cutoff}{Cutoff value of RPKM at 0hr.}

\item{cutoffBelow}{Cutoff value of RPKM at all time points.}

\item{inforColumn}{The number of information columns.}

\item{save}{Whether to save the output matrix file.}

\item{outputPrefix}{The prefix for the name of the output.}
}
\value{
data.table object about relative RPKM values.
}
\description{
\code{BridgeRDataSetFromRaw} calculates the relative RPKM values
compared with 0hr, importing tab-delimited txt file.
}

