% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bq_transactions.R
\name{bq_transactions}
\alias{bq_transactions}
\title{Briq transactions}
\usage{
bq_transactions(max_results_per_page = 100, pause_between_pages = 0,
  organization = Sys.getenv("organization_name"),
  api_token = Sys.getenv("briq_api_token"))
}
\arguments{
\item{max_results_per_page}{Maximum number of results per page}

\item{pause_between_pages}{Number of seconds to wait between page requests}

\item{organization}{Name of your Briq organization}

\item{api_token}{Briq API token}
}
\value{
Returns a tibble of Briq transactions of your organization
}
\description{
List all the 'Briq' transactions of your organization
}
\examples{
\dontrun{
# Read organization and api_token from .Renviron file
bq_transactions()

# Manually enter in organization and api_token
bq_transactions(organization = "My Org", api_token = "xYz123")
}
}
