% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Scree.R
\name{scree}
\alias{scree}
\title{scree: Scree Plot with Pairwise Complete Cases}
\usage{
scree(data)
}
\arguments{
\item{data}{N by P data matrix.}
}
\value{
Returns eigenvalues and scree plot.
}
\description{
This function provides a scree plot when data may be missing.
}
\examples{
set.seed(999)
your_data=data.frame(mvrnorm(n=20,mu=c(0,0,0,0,0),
                            Sigma=matrix(c(4,2,2,2,2,
                                           2,4,2,2,2,
                                           2,2,4,2,2,
                                           2,2,2,4,2,
                                           2,2,2,2,4),
                                         nrow=5, ncol=5)))
colnames(your_data)=c("x1","x2","x3","x4","x5")
your_data_miss=matrix(ncol=5,nrow=20)
for (i in 1:20){
 for (p in 1:5){
   your_data_miss[i,p]=ifelse(runif(1,0,1)<0.2,NA,your_data[i,p])
 }
}
scree(your_data_miss)

}
