% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Summarize.R
\name{summarize}
\alias{summarize}
\title{summarize: Summarize Stan output as median, SD, and HPD quantiles}
\usage{
summarize(Samples, nrow, ncol, CI)
}
\arguments{
\item{Samples}{S by theta matrix of sampled parameter estimates.}

\item{nrow}{Number of rows of target summary matrix}

\item{ncol}{Number of columns of target summary matrix}

\item{CI}{Creddible interval quantile, as a decimal (ie, for 95 percent, 0.95)}
}
\value{
Returns median, SD, and HPD CI limits
}
\description{
This function converts raw MCMC sample data into matrix formatted summaries
}
\examples{
\dontrun{
your_data_s=standardize(your_data)
formatted_data=prep(your_data_s,nfactors=3)
out=sampling(model, data=formatted_data, iter=5000, seed=999)
res=as.matrix(out)
unpacked=unpack(Samples=res,Format=formatted_data)
processed=process(Loading_Matrix=unpacked$Loading_Matrix,
                 Format=formatted_data,
                 Rotate="oblimin")

summarize(processed$Loadings,
         nrow=Formatted_data$P,
         ncol=Formatted_data$Q)$Table
summarize(processed$Communality,
         nrow=Formatted_data$P,
         ncol=1)$Table
summarize(processed$Uniqueness,
         nrow=Formatted_data$P,
         ncol=1)$Table
summarize(processed$G_Factor,
         nrow=Formatted_data$P,
         ncol=1)$Table
summarize(processed$Interfactor_Correlations,
         nrow=Formatted_data$Q,
         ncol=Formatted_data$Q)$Table
summarize(processed$Omega,
         nrow=1,
         ncol=1)$Table
summarize(unpacked$Tau_Matrix,
         nrow=Formatted_data$P,
         ncol=1)$Table}

}
