% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabs.R
\name{insertTab}
\alias{insertTab}
\title{Insert a \link[shiny]{tabPanel} in a \link{tabsetPanel}}
\usage{
insertTab(
  inputId,
  tab,
  target,
  position = c("before", "after"),
  select = FALSE,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{inputId}{\link{tabsetPanel} id.}

\item{tab}{\link[shiny]{tabPanel} to insert.}

\item{target}{\link[shiny]{tabPanel} after of before which the new tab will be inserted.}

\item{position}{Insert before or after: \code{c("before", "after")}.}

\item{select}{Whether to select the newly inserted tab. FALSE by default.}

\item{session}{Shiny session object.}
}
\description{
Insert a \link[shiny]{tabPanel} in a \link{tabsetPanel}
}
\examples{
if (interactive()) {
 library(shiny)
 library(bs4Dash)

 shinyApp(
  ui = dashboardPage(
    header = dashboardHeader(),
    sidebar = dashboardSidebar(),
    controlbar = dashboardControlbar(),
    footer = dashboardFooter(),
    title = "Handle tabs",
    body = dashboardBody(
      actionButton("add", "Add 'Dynamic' tab"),
      actionButton("remove", "Remove 'Foo' tab"),
      actionButton("hideTab", "Hide 'Foo' tab"),
      actionButton("showTab", "Show 'Foo' tab"),
      br(), br(),
      tabBox(
        id = "tabs",
        title = "A card with tabs",
        selected = "Bar",
        status = "primary",
        solidHeader = FALSE,
        type = "tabs",
        tabPanel("Hello", "This is the hello tab"),
        tabPanel("Foo", "This is the foo tab"),
        tabPanel("Bar", "This is the bar tab")
      )
    )
  ),
  server = function(input, output, session) {
    observeEvent(input$add, {
      insertTab(
        inputId = "tabs",
        tabPanel("Dynamic", "This a dynamically-added tab"),
        target = "Bar",
        select = TRUE
      )
    })

    observeEvent(input$remove, {
      removeTab(inputId = "tabs", target = "Foo")
    })

    observeEvent(input$hideTab, {
      hideTab(inputId = "tabs", target = "Foo")
    })

    observeEvent(input$showTab, {
      showTab(inputId = "tabs", target = "Foo")
    })
  }
 )
}
}
