% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsnsing.R
\name{binarize.numeric}
\alias{binarize.numeric}
\title{Create Binary Features based on a Numeric Vector}
\usage{
binarize.numeric(
  x,
  name,
  y,
  target = stop("Must provide a target, 0 or 1"),
  segments = 10,
  bin.size = 5,
  node.size = 10
)
}
\arguments{
\item{x}{a numeric vector.}

\item{name}{a character string, the variable name of \code{x}.}

\item{y}{a numeric or integer vector of the same length as \code{x}, consisting of two unique values: 0 and 1.}

\item{target}{a scalar, valued 0 or 1, indicating the target level of \code{y}.}

\item{segments}{a positive integer, any value below 3 is set to 3. It is the maximum number of segments the range of \code{x} is divided into.}

\item{bin.size}{a positive integer. It is the minimum number of observations required to fall into each bin.}

\item{node.size}{a positive integer. If either child node is smaller than the node.size, do not return the perfect rule.}
}
\value{
a data frame with binary (0 and 1) entries, or a character string describing the rule that perfectly splits \code{y}. If a data frame is returned, the column names are indicative of the conditions used to form the corresponding columns.
}
\description{
Discretize a continuous variable \code{x} by splitting its range at a sequence of cutpoints. The cutpoints are determined so as to effectively split the binary target \code{y}. This function is used internally by \code{\link{binarize}}.
}
