% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsnsing.R
\name{bscontrol}
\alias{bscontrol}
\title{Define Parameters for the \code{\link{bsnsing}} Fit}
\usage{
bscontrol(
  bin.size = 5,
  nseg.numeric = 20,
  nseg.factor = 20,
  num2factor = 10,
  node.size = 0,
  stop.prob = 0.9999,
  opt.solver = c("enum_c", "enum"),
  solver.timelimit = 180,
  max.rules = 2,
  opt.model = c("gini", "error"),
  greedy.level = 0.9,
  import.external = TRUE,
  suppress.internal = FALSE,
  no.same.gender.children = FALSE,
  n0n1.cap = 40000,
  verbose = FALSE
)
}
\arguments{
\item{bin.size}{the minimum number of observations required in a binarization bucket.}

\item{nseg.numeric}{the maximum number of segments the range of a numeric variable is divided into for each inequality direction.}

\item{nseg.factor}{the maximum number of unique levels allowed in a factor variable.}

\item{num2factor}{an equality binarization rule will be created for each unique value of a numeric variable (in addition to the inequality binarization attempt), if the number of unique values of the numeric variable is less than \code{num2factor}.}

\item{node.size}{if the number of training cases falling into a tree node is fewer than \code{node.size}, the node will become a leaf and no further split will be attempted on it; in addition, do not split a node if either child node that would result from the split contains fewer than \code{node.size} observation. Default is 0, which indicates that the node.size will be set automatically according to this formula: floor(sqrt(Number of training cases)).}

\item{stop.prob}{if the proportion of the majority class in a tree node is greater than \code{stop.prob}, the node will become a leaf and no further split will be attempted on it.}

\item{opt.solver}{a character string in the set {'enum', 'enum_c', 'gurobi', 'cplex', 'lpSolve', 'greedy'} indicating the optimization solver to be used in the program. The choice of 'cplex' requires the package \code{cplexAPI}, 'gurobi' requires the package \code{gurobi}, and 'lpSolve' requires the package \code{lpSolve}. These solver options are only available in the full version at \url{https://github.com/profyliu/bsnsing/}. The default (and the best) is 'enum_c'.}

\item{solver.timelimit}{the solver time limit in seconds. Note that this limits the time it takes to optimize each node split.}

\item{max.rules}{the maximum number of features allowed to enter an OR-clause split rule. A small max.rules reduces the search space and regulates model complexity. Default is 2.}

\item{opt.model}{a character string in the set {'gini','error'} indicating the optimization model to solve in the program. The default is 'gini'. The 'error' option is not available in the current version.}

\item{greedy.level}{a proportion value between 0 and 1, applicable only when opt.solver is 'greedy'. In the greedy forward selection process of split rules, a candidate rule is added to the OR-clause only if the split performance (gini reduction or accuracy) after the addition multiplied by greedy.level would still be greater than the split performance before the addition. A higher value of greedy.level tend to more aggressively produce multi-variable splits. Only available in the full version.}

\item{import.external}{logical value indicating whether or not to try importing candidate split rules from other decision tree packages. Default is True.}

\item{suppress.internal}{logical value indicating whether or not to suppress the feature binarization process that creates the pool of binary features. If it is set to True, then only the features imported from external methods (if import.external is True) will be used in the optimal rule selection model. Default is FALSE.}

\item{no.same.gender.children}{logical value indicating whether or not to suppress splits that would result in both children having the same majority class. Default is FASLE.}

\item{n0n1.cap}{a positive integer. It is applicable only when the opt.solver is 'hybrid' and the opt.model is 'gini'. When the bslearn function is called, if the product of the number of negative cases (n0) and the number of positive cases (n1) is greater than this number, 'enum' solver will be used; otherwise, gurobi solver will be used. Only available in the full version.}

\item{verbose}{a logical value (TRUE or FALSE) indicating whether the solution details are to be printed on the screen.}
}
\value{
An object of class \code{\link{bscontrol}}.
}
\description{
Define Parameters for the \code{\link{bsnsing}} Fit
}
\examples{
bscontrol()  # display the default parameters
bsc <- bscontrol(stop.prob = 0.8, nseg.numeric = 10, verbose = TRUE)
bsc
}
