% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_bunching.R
\name{plot_bunching}
\alias{plot_bunching}
\title{Bunching Plot}
\usage{
plot_bunching(
  z_vector,
  binned_data,
  cf,
  zstar,
  binwidth,
  bins_excl_l = 0,
  bins_excl_r = 0,
  p_title = "",
  p_xtitle = deparse(substitute(z_vector)),
  p_ytitle = "Count",
  p_miny = 0,
  p_maxy = NA,
  p_ybreaks = NA,
  p_title_size = 11,
  p_axis_title_size = 10,
  p_axis_val_size = 8.5,
  p_freq_color = "black",
  p_cf_color = "maroon",
  p_zstar_color = "red",
  p_grid_major_y_color = "lightgrey",
  p_freq_size = 0.5,
  p_freq_msize = 1,
  p_cf_size = 0.5,
  p_zstar_size = 0.5,
  p_b = FALSE,
  b = NA,
  b_sd = NA,
  p_e = FALSE,
  e = NA,
  e_sd = NA,
  p_b_e_xpos = NA,
  p_b_e_ypos = NA,
  p_b_e_size = 3,
  t0 = NA,
  t1 = NA,
  notch = FALSE,
  p_domregion_color = NA,
  p_domregion_ltype = NA
)
}
\arguments{
\item{z_vector}{a numeric vector of (unbinned) data.}

\item{binned_data}{binned data with frequency and estimated counterfactual.}

\item{cf}{the counterfactual to be plotted.}

\item{zstar}{a numeric value for the the bunching point.}

\item{binwidth}{a numeric value for the width of each bin.}

\item{bins_excl_l}{number of bins to left of zstar to include in bunching region. Default is 0.}

\item{bins_excl_r}{number of bins to right of zstar to include in bunching region. Default is 0.}

\item{p_title}{plot's title. Default is empty.}

\item{p_xtitle}{plot's x_axis label. Default is the name of z_vector.}

\item{p_ytitle}{plot's y_axis label. Default is "Count".}

\item{p_miny}{plot's minimum y_axis value. Default is 0.}

\item{p_maxy}{plot's maximum y_axis value. Default is optimized internally.}

\item{p_ybreaks}{a numeric vector of y-axis values at which to add horizontal line markers in plot. Default is optimized internally.}

\item{p_title_size}{size of plot's title. Default is 11.}

\item{p_axis_title_size}{size of plot's axes' title labels. Default is 10.}

\item{p_axis_val_size}{size of plot's axes' numeric labels. Default is 8.5.}

\item{p_freq_color}{plot's frequency line color. Default is "black".}

\item{p_cf_color}{plot's counterfactual line color. Default is "maroon".}

\item{p_zstar_color}{plot's bunching region marker lines color. Default is "red".}

\item{p_grid_major_y_color}{plot's y-axis major grid line color. Default is "lightgrey".}

\item{p_freq_size}{plot's frequency line thickness. Default is 0.5.}

\item{p_freq_msize}{plot's frequency line marker size. Default is 1.}

\item{p_cf_size}{plot's counterfactual line thickness. Default is 0.5.}

\item{p_zstar_size}{plot's bunching region marker line thickness. Default is 0.5.}

\item{p_b}{whether plot should also include the bunching estimate. Default is FALSE.}

\item{b}{normalized bunching estimate.}

\item{b_sd}{standard deviation of the normalized bunching estimate.}

\item{p_e}{whether plot should also include the elasticity estimate. Only shown if p_b is TRUE. Default is FALSE.}

\item{e}{elasticity estimate.}

\item{e_sd}{standard deviation of the elasticity estimate.}

\item{p_b_e_xpos}{plot's x-axis coordinate of bunching/elasticity estimate. Default is set internally.}

\item{p_b_e_ypos}{plot's y-axis coordinate of bunching/elasticity estimate. Default is set internally.}

\item{p_b_e_size}{size of plot's printed bunching/elasticity estimate. Default is 3.}

\item{t0}{numeric value setting the marginal (average) tax rate below zstar in a kink (notch) setting.}

\item{t1}{numeric value setting the marginal (average) tax rate above zstar in a kink (notch) setting.}

\item{notch}{whether analysis is for a kink or notch. Default is FALSE (kink).}

\item{p_domregion_color}{plot's dominated region marker line color in notch setting. Default is "blue".}

\item{p_domregion_ltype}{line type for the vertical line type marking the dominated region (zD) in the plot for notch settings. Default is "longdash".}
}
\value{
\code{plot_bunching} returns a plot with the frequency, counterfactual and bunching region demarcated. Can also include the bunching and elasticity estimate if specified.
}
\description{
Creates the bunching plot.
}
\examples{
data(bunching_data)
binned_data <- bin_data(z_vector = bunching_data$kink, zstar = 10000,
                        binwidth = 50, bins_l = 20, bins_r = 20)
prepped_data <- prep_data_for_fit(binned_data, zstar = 10000, binwidth = 50,
                                  bins_l = 20, bins_r = 20, poly = 4)
fitted <- fit_bunching(thedata = prepped_data$data_binned,
                       themodelformula = prepped_data$model_formula,
                       binwidth = 50)
plot_bunching(z_vector = bunching_data$kink_vector,
              binned_data = prepped_data$data_binned,
              cf = fitted$cf_density, zstar = 10000,
              binwidth = 50, bins_excl_l = 0 , bins_excl_r = 0,
              b = 1.989, b_sd = 0.005, p_b = TRUE)
}
\seealso{
\code{\link{bunchit}}
}
