#' IACGMOOH contestants data
#'
#' Data on each of the celebrity contestants in the first 24 seasons of the
#' UK TV show "I'm A Celebrity, Get Me Out Of Here"
#'
#' @format ## `contestants`
#' A data frame with 282 rows and 12 columns:
#' \describe{
#'   \item{season}{(\emph{numeric}) Season of the show}
#'   \item{first_name}{(\emph{character}) First name of the celebrity contestant}
#'   \item{nickname}{(\emph{character}) Nickname/preferred name of the celebrity contestant (if they have one)}
#'   \item{last_name}{(\emph{character}) Last name of the celebrity contestant}
#'   \item{famous_for}{(\emph{character}) What the celebrity is most known for}
#'   \item{position}{(\emph{numeric}) Their overall position in this season (1 = winner, 2 = runner-up, etc.)}
#'   \item{position_desc}{(\emph{character}) Description of the celebrity's position, and when they were eliminated}
#'   \item{date_eliminated}{(\emph{Date}) Date the celebrity left the show - either by elimination or withdrawal}
#'   \item{trials_attempted}{(\emph{numeric}) Number of bushtucker trials attempted}
#'   \item{stars_available}{(\emph{numeric}) Number of stars available in all bushtucker trials attempted}
#'   \item{stars_won}{(\emph{numeric}) Number of stars successfully won in all bushtucker trials attempted}
#'   \item{trial_performance}{(\emph{numeric}) Ratio of stars won to stars available}
#' }
#' @source <https://en.wikipedia.org/wiki/I%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_1>
#' @source <https://en.wikipedia.org/wiki/I%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_2>
#' @source <https://en.wikipedia.org/wiki/I%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_3>
#' @source <https://en.wikipedia.org/wiki/I%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_4>
#' @source <https://en.wikipedia.org/wiki/I%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_5>
#' @source <https://en.wikipedia.org/wiki/I%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_6>
#' @source <https://en.wikipedia.org/wiki/I%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_7>
#' @source <https://en.wikipedia.org/wiki/I%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_8>
#' @source <https://en.wikipedia.org/wiki/I%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_9>
#' @source <https://en.wikipedia.org/wiki/I%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_10>
#' @source <https://en.wikipedia.org/wiki/I%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_11>
#' @source <https://en.wikipedia.org/wiki/I%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_12>
#' @source <https://en.wikipedia.org/wiki/I%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_13>
#' @source <https://en.wikipedia.org/wiki/I%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_14>
#' @source <https://en.wikipedia.org/wiki/I%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_15>
#' @source <https://en.wikipedia.org/wiki/I%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_16>
#' @source <https://en.wikipedia.org/wiki/I%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_17>
#' @source <https://en.wikipedia.org/wiki/I%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_18>
#' @source <https://en.wikipedia.org/wiki/I%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_19>
#' @source <https://en.wikipedia.org/wiki/I%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_20>
#' @source <https://en.wikipedia.org/wiki/I%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_21>
#' @source <https://en.wikipedia.org/wiki/I%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_22>
#' @source <https://en.wikipedia.org/wiki/I%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_23>
#' @source <https://en.wikipedia.org/wiki/I%27m_a_Celebrity...Get_Me_Out_of_Here!_(British_TV_series)_series_24>
#'
#' @examples{
#' # How many singers have been on the show?
#' sum(grepl("singer", contestants$famous_for, ignore.case = TRUE))
#'
#' # Who has the worst overall trial performance across all seasons?
#' contestants[
#' which.min(contestants$trial_performance),
#' c("first_name", "last_name", "trials_attempted", "trial_performance")
#' ]
#' }
"contestants"
