% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_kbl_by_types.R
\docType{methods}
\name{kbl_by_types}
\alias{kbl_by_types}
\alias{kbl_by_types,operations-method}
\alias{kbl_by_types,-methods}
\title{Format table from collection of types of operations objects}
\usage{
kbl_by_types(
  obj,
  types,
  resolution = c("year", "quarter", "month"),
  currency = "€",
  digits = 0,
  DIY = FALSE,
  font_size = NULL,
  latex_options = "striped",
  stripe_color = "gray!6",
  years = get_period(obj, years = TRUE),
  sum_names = c(subtotal = "Subtotal", total = "Total"),
  type_colors = c(color = "white", background = "grey"),
  space = c(html = "&#8239;", latex = "\\\\,"),
  ...
)

\S4method{kbl_by_types}{operations}(
  obj,
  types,
  resolution = c("year", "quarter", "month"),
  currency = "€",
  digits = 0,
  DIY = FALSE,
  font_size = NULL,
  latex_options = "striped",
  stripe_color = "gray!6",
  years = get_period(obj, years = TRUE),
  sum_names = c(subtotal = "Subtotal", total = "Total"),
  type_colors = c(color = "white", background = "grey"),
  space = c(html = "&#8239;", latex = "\\\\,"),
  ...
)
}
\arguments{
\item{obj}{An object of class \code{\link[businessPlanR:operations-class]{operations}} or \code{\link[businessPlanR:loan-class]{loan}}.}

\item{types}{A named character vector of types to fetch from \code{obj} and print in the resulting table.
Names must be the type names,
      their value must be one of \code{"revenue"} or \code{"expense"} so the method knows what
to use in case identical type names are defined for both.}

\item{resolution}{One of \code{"month"}, \code{"quarter"}, or \code{"year"}.}

\item{currency}{Character defining a currency symbol.}

\item{digits}{Integer, round values to number of digits.}

\item{DIY}{Logical,
      if \code{TRUE} returns the \code{kable} object prior to any row packing, specs or kable styling,
so you can apply all of those as you wish.}

\item{font_size}{Passed to \code{\link[kableExtra:kable_styling]{kable_styling}}.}

\item{latex_options}{Passed to \code{\link[kableExtra:kable_styling]{kable_styling}}.}

\item{stripe_color}{Passed to \code{\link[kableExtra:kable_styling]{kable_styling}}.}

\item{years}{Character (or numeric) vector defining the year(s) to be represented in the output. This is intended to be
useful for splitting up quarterly or monthly output.}

\item{sum_names}{A named character vector with two entries,
      \code{subtotal} and \code{total},
to be used in the resulting table for those values.}

\item{type_colors}{A named character vector with two entries,
      \code{color} and \code{background}, defining the color scheme
for type headlines.}

\item{space}{Character, a space definition to put between currency and value.}

\item{...}{Additional arguments passed on to \code{\link[kableExtra:kbl]{kbl}}.}
}
\value{
An object of class \code{kable}.
}
\description{
This method uses the \code{kableExtra} package for table formatting.
}
