% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_update_operations.R
\docType{methods}
\name{update_operations<-}
\alias{update_operations<-}
\alias{update_operations<-,operations-method}
\alias{update_operations<-,-methods}
\title{Update operations objects}
\usage{
update_operations(obj, cut_to_period = TRUE, warning = FALSE, as_transaction) <- value

\S4method{update_operations}{operations}(obj, cut_to_period = TRUE, warning = FALSE,
      as_transaction) <- value
}
\arguments{
\item{obj}{An object of class \code{\link[businessPlanR:operations-class]{operations}}.}

\item{cut_to_period}{Logical,
      whether to adjust the data of \code{value} to the period covered by \code{obj}. This means that missing months
will be added with zero values,
      and months that lie beyond the covered period will be dropped.
This only affects objects of class \code{revenue} and \code{expense}.}

\item{warning}{Logical,
      if \code{TRUE} shows a warning when \code{cut_to_period=TRUE} and months are adjusted.}

\item{as_transaction}{Optional list of vectors of arguments for \code{value} of class \code{\link[businessPlanR:loan-class]{loan}} or
\code{\link[businessPlanR:depreciation-class]{depreciation}},
      as used by \code{\link[businessPlanR:as_transaction]{as_transaction}}.
If given,
      the object provided as \code{value} will also be processed as if \code{as_transaction} was also called. This is repeated
for each vector of arguments.}

\item{value}{An object of either class \code{\link[businessPlanR:revenue-class]{revenue}},
      \code{\link[businessPlanR:expense-class]{expense}},
\code{\link[businessPlanR:loan-class]{loan}},
      \code{\link[businessPlanR:depreciation-class]{depreciation}}, or
\code{\link[businessPlanR:transaction_plan-class]{transaction_plan}}.}
}
\value{
An updated object of class \code{operations}.
}
\description{
You can use this method to add or replace transactions to an existing object of class
\code{\link[businessPlanR:operations-class]{operations}}.
}
