% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spark.R
\name{axe-spark}
\alias{axe-spark}
\alias{axe_call.ml_model}
\alias{axe_ctrl.ml_model}
\alias{axe_data.ml_model}
\alias{axe_fitted.ml_model}
\title{Axing a spark object.}
\usage{
\method{axe_call}{ml_model}(x, verbose = FALSE, ...)

\method{axe_ctrl}{ml_model}(x, verbose = FALSE, ...)

\method{axe_data}{ml_model}(x, verbose = FALSE, ...)

\method{axe_fitted}{ml_model}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{A model object.}

\item{verbose}{Print information each time an axe method is executed.
Notes how much memory is released and what functions are
disabled. Default is \code{FALSE}.}

\item{...}{Any additional arguments related to axing.}
}
\value{
Axed spark object.
}
\description{
spark objects are created from the \pkg{sparklyr} package,
a \R interface for Apache Spark. The axe methods available
for spark objects are designed such that interoperability
is maintained. In other words, for a multilingual machine
learning team, butchered spark objects instantiated from
\pkg{sparklyr} can still be serialized to disk, work in
Python, be deployed on Scala, etc. It is also worth noting
here that spark objects created from \pkg{sparklyr} have a
lot of metadata attached to it, including but not limited
to the formula, dataset, model, index labels, etc. The
axe functions provided are for parsing down the model
object both prior saving to disk, or loading from disk.
Traditional \R save functions are not available for these
objects, so functionality is provided in \code{sparklyr::ml_save}.
This function gives the user the option to keep either the
\code{pipeline_model} or the \code{pipeline}, so both of these
objects are retained from butchering, yet removal of one or the
other might be conducive to freeing up memory on disk.
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(sparklyr)

sc <- spark_connect(master = "local")

iris_tbls <- sdf_copy_to(sc, iris, overwrite = TRUE) \%>\%
  sdf_random_split(train = 2/3, validation = 2/3, seed = 2018)

train <- iris_tbls$train
spark_fit <- ml_logistic_regression(train, Species ~ .)

out <- butcher(spark_fit, verbose = TRUE)

spark_disconnect(sc)
\dontshow{\}) # examplesIf}
}
