% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predictRaw}
\alias{predictRaw}
\title{Predict raw values}
\usage{
predictRaw(norm, age, coefficients, minRaw = -Inf, maxRaw = Inf)
}
\arguments{
\item{norm}{The norm score, e. g. a specific T score or a vector of scores}

\item{age}{The age value or a vector of scores}

\item{coefficients}{The a cnorm object or the coefficients from the regression model}

\item{minRaw}{Minimum score for the results; can be used for clipping unrealistic outcomes,
usually set to the lower bound of the range of values of the test (default: 0)}

\item{maxRaw}{Maximum score for the results; can be used for clipping unrealistic outcomes
usually set to the upper bound of the range of values of the test}
}
\value{
the predicted raw score or a data.frame of scores in case, lists of norm scores or age is used
}
\description{
Most elementary function to predict raw score based on Location (L, T score),
Age (grouping variable) and the coefficients from a regression model.
}
\examples{
# Prediction of single scores
model <- cnorm(raw = elfe$raw, group = elfe$group)
predictRaw(35, 3.5, model)


}
\seealso{
Other predict: 
\code{\link{derivationTable}()},
\code{\link{getNormCurve}()},
\code{\link{normTable}()},
\code{\link{predict.cnormBetaBinomial}()},
\code{\link{predict.cnormBetaBinomial2}()},
\code{\link{predict.cnormShash}()},
\code{\link{predictNorm}()},
\code{\link{rawTable}()}
}
\concept{predict}
