% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sca.R
\name{sca}
\alias{sca}
\title{Performs standard Correspondence Analysis calculations}
\usage{
sca(X, catype = "sca", mcatype = NULL, p = 2, needtrans = FALSE)
}
\arguments{
\item{X}{A data matrix with rows >= cols}

\item{catype}{Can be "sca" for simple CA or "mca" for multiple CA}

\item{mcatype}{If catype="mca" then this can be "Burt", "Indicator"
or "doubled" depending on the analysis required.\cr
This affects the number of meaningful singular values, as does p below}

\item{p}{Number of variables, only needed if catype="mca"}

\item{needtrans}{TRUE if rows < columns so need to transpose in the routine}
}
\value{
An object of class \code{\linkS4class{cabasicresults}}
}
\description{
\code{sca} returns all the basic results from a CA of a matrix with rows >= cols,
in an object of class \code{\linkS4class{cabasicresults}}
}
\details{
This is only intended for internal use by the \code{\link{cabootcrs}} function.
}
\examples{
results <- sca(as.matrix(DreamData))

}
\seealso{
\code{\link{cabootcrs-package}}, \code{\link{cabootcrs}}, \code{\linkS4class{cabasicresults}}
}
