% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_options.R
\name{plotting_options}
\alias{plotting_options}
\alias{plot_common_scale}
\alias{get_plot_opts}
\alias{patch_plots}
\title{General plotting options}
\usage{
plot_common_scale(plots)

get_plot_opts(common_scale = TRUE)

patch_plots(plots, selection = names(plots), plot_options = get_plot_opts())
}
\arguments{
\item{plots}{A list of (named) plots, as returned by \code{\link[=plot]{plot()}}.}

\item{common_scale}{Logical specifying whether to
have plots in a common scale.}

\item{selection}{A character or numeric vector determining the plots to patch}

\item{plot_options}{A list of plot options as returned by \code{\link[=get_plot_opts]{get_plot_opts()}}}
}
\value{
\code{plot_common_scale()} returns a list of plots.

\code{get_plot_opts()} returns a list.

\code{patch_plots()} returns a \code{patchwork} object.
}
\description{
\code{plot_common_scale()} rescales a list of
plots to have a common scale.

\code{get_plot_opts()} returns generic plotting options.

\code{patch_plots()} patches plots using \code{patchwork} package.
}
