% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/target_population.R
\name{get_filtered_population}
\alias{get_filtered_population}
\title{Filters the Population}
\usage{
get_filtered_population(
  year,
  min_age,
  max_age,
  modifier = 1,
  level = c("country", "county", "subcounty"),
  pop_sex = c("female", "male", "both"),
  rate = 0.022
)
}
\arguments{
\item{year}{The year to project the population}

\item{min_age}{The minimum age to include in the filtered data}

\item{max_age}{The maximum age to include in the filtered data}

\item{modifier}{A multiplier that affect the population projection. Default 1}

\item{level}{The desired level of the organization unit hierarchy to retrieve
data for: \code{"country"}, \code{"county"} or \code{"subcounty"}.}

\item{pop_sex}{The desired population sex: \code{"male"}, \code{"female"} (default), \code{"both"}}

\item{rate}{The population growth}
}
\value{
A tibble containing the target population
}
\description{
\code{get_filtered_population()} filters the population based on age and level
and projects the population base on the year provided
}
\examples{

# Get the female population in 2022 aged 25-49 years
filtered_population <- get_filtered_population(2022, 25, 49, pop_sex = 'female')
filtered_population

# Get 5\% male population in 2022 aged 40-75 years
filtered_population <- get_filtered_population(2022, 40, 75, modifier = 0.05, pop_sex = 'male')
filtered_population
}
