% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_control.R
\name{fit_control}
\alias{fit_control}
\title{Set \code{feglm} Control Parameters}
\usage{
fit_control(
  dev_tol = 1e-08,
  center_tol = 1e-08,
  collin_tol = 1e-10,
  step_halving_factor = 0.5,
  alpha_tol = 1e-08,
  iter_max = 25L,
  iter_center_max = 10000L,
  iter_inner_max = 50L,
  iter_alpha_max = 10000L,
  iter_interrupt = 1000L,
  iter_ssr = 10L,
  step_halving_memory = 0.9,
  max_step_halving = 2L,
  start_inner_tol = 1e-06,
  accel_start = 6L,
  project_tol_factor = 0.001,
  grand_accel_tol = 1e-10,
  project_group_tol = 1e-12,
  irons_tuck_tol = 1e-10,
  grand_accel_interval = 5L,
  irons_tuck_interval = 3L,
  ssr_check_interval = 40L,
  convergence_factor = 1.1,
  tol_multiplier = 20,
  return_fe = TRUE,
  keep_tx = FALSE,
  init_theta = 0
)
}
\arguments{
\item{dev_tol}{tolerance level for the first stopping condition of the
maximization routine. The stopping condition is based on the relative change
of the deviance in iteration \eqn{r} and can be expressed as follows:
\eqn{|dev_{r} - dev_{r - 1}| / (0.1 + |dev_{r}|) < tol}{|dev - devold| /
 (0.1 + |dev|) < tol}. The default is \code{1.0e-08}.}

\item{center_tol}{tolerance level for the stopping condition of the centering
algorithm. The stopping condition is based on the relative change of the
centered variable similar to the \code{'lfe'} package. The default is
\code{1.0e-08}.}

\item{collin_tol}{tolerance level for detecting collinearity. The default is
\code{1.0e-07}.}

\item{step_halving_factor}{numeric indicating the factor by which the step
size is halved to iterate towards convergence. This is used to control the
step size during optimization. The default is \code{0.5}.}

\item{alpha_tol}{tolerance for fixed effects (alpha) convergence.
The default is \code{1.0e-06}.}

\item{iter_max}{unsigned integer indicating the maximum number of iterations
in the maximization routine. The default is \code{25L}.}

\item{iter_center_max}{unsigned integer indicating the maximum number of
iterations in the centering algorithm. The default is \code{10000L}.}

\item{iter_inner_max}{unsigned integer indicating the maximum number of
iterations in the inner loop of the centering algorithm. The default is
\code{50L}.}

\item{iter_alpha_max}{maximum iterations for fixed effects computation.
The default is \code{10000L}.}

\item{iter_interrupt}{unsigned integer indicating the maximum number of
iterations before the algorithm is interrupted. The default is \code{1000L}.}

\item{iter_ssr}{unsigned integer indicating the number of iterations
to skip before checking if the sum of squared residuals improves. The default
is \code{10L}.}

\item{step_halving_memory}{numeric memory factor for step-halving algorithm.
Controls how much of the previous iteration is retained. The default is \code{0.9}.}

\item{max_step_halving}{maximum number of post-convergence step-halving attempts.
The default is \code{2}.}

\item{start_inner_tol}{starting tolerance for inner solver iterations.
The default is \code{1.0e-04}.}

\item{accel_start}{Integer. Iteration to start conjugate gradient acceleration in centering.
The default is \code{6L}.}

\item{project_tol_factor}{Factor to multiply center_tol for projection tolerance.
The default is \code{1e-3}.}

\item{grand_accel_tol}{Tolerance for grand acceleration convergence.
The default is \code{1e-10}.}

\item{project_group_tol}{Tolerance for individual group projections.
The default is \code{1e-12}.}

\item{irons_tuck_tol}{Tolerance for Irons-Tuck acceleration.
The default is \code{1e-10}.}

\item{grand_accel_interval}{Interval for applying grand acceleration.
The default is \code{5L}.}

\item{irons_tuck_interval}{Interval for applying Irons-Tuck acceleration.
The default is \code{3L}.}

\item{ssr_check_interval}{Interval for adaptive SSR convergence checks.
The default is \code{40L}.}

\item{convergence_factor}{Factor for detecting slow convergence.
The default is \code{1.1}.}

\item{tol_multiplier}{Multiplier for early termination tolerance check.
The default is \code{20.0}.}

\item{return_fe}{logical indicating if the fixed effects should be returned.
This can be useful when fitting general equilibrium models where skipping the
fixed effects for intermediate steps speeds up computation. The default is
\code{TRUE} and only applies to the \code{feglm} class.}

\item{keep_tx}{logical indicating if the centered regressor matrix should be
stored. The centered regressor matrix is required for some covariance
estimators, bias corrections, and average partial effects. This option saves
some computation time at the cost of memory. The default is \code{TRUE}.}

\item{init_theta}{Initial value for the negative binomial dispersion parameter (theta).
The default is \code{0.0}.}
}
\value{
A named list of control parameters.
}
\description{
Set and change parameters used for fitting \code{\link{feglm}}.
Termination conditions are similar to \code{\link[stats]{glm}}.
}
\examples{
fit_control(0.05, 0.05, 10L, 10L, TRUE, TRUE, TRUE)

}
\seealso{
\code{\link{feglm}}
}
