% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowtabmat.R
\name{flowtabmat}
\alias{flowtabmat}
\title{Changing the format of a flow dataset}
\usage{
flowtabmat(tab, matlist)
}
\arguments{
\item{tab}{flow dasaset, in matrice or long format}

\item{matlist}{choose "matrice" or "long" for the resulting format. See Details.}
}
\value{
a flow dataset in matrice or in long format
}
\description{
Transform a flow dataset from long to matrice format, and vice versa. 
Square matrice.
}
\details{
- matlist="M" from long (3 columns : origin, destination, flow) to matrice format [n*n];\cr
- matlist="L" from matrice to long format.
}
\examples{
library(cartograflow)
data(flowdata)
# 1: From long to matrix format (n*m)
matFlow <- flowtabmat(flows, matlist = "M")
# 2: From matrix to long format [i,j,Fij]
listflow <- flowtabmat(matFlow, matlist = "L")
}
