% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style-pronoun.R
\docType{data}
\name{dot-style}
\alias{dot-style}
\alias{.style}
\title{\code{.style} pronoun}
\description{
The \code{.style} pronoun allows defining styles within the function call of a tag
element. Without the \code{.style} pronoun tag element styles are applied outside
and after constructing a tag element.

\if{html}{\out{<div class="sourceCode R">}}\preformatted{div() \%>\%
  background_color("primary") \%>\%
  display("flex") \%>\%
  flex_justify("between")
}\if{html}{\out{</div>}}

Once the content of a tag element grows to more than a few lines, associating
the element's styles with the element becomes less and less intuitive. In
these situations, make use of the \code{.style} pronoun.

\if{html}{\out{<div class="sourceCode R">}}\preformatted{div(
  .style \%>\%
    border_color(theme_primary()) \%>\%
    text_color(theme_primary()),
  p("Paragraph"),
  p("Paragraph"),
  p("Paragraph")
)
}\if{html}{\out{</div>}}
}
\keyword{datasets}
