% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item-align.R
\name{item_align}
\alias{item_align}
\title{Flex align self}
\usage{
item_align(x, ...)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{...}{A character string specifying an alignment. One of,
\itemize{
\item \code{"start"}
\item \code{"end"}
\item \code{"center"}
\item \code{"baseline"}
\item \code{"stretch"}

Use name-value pairs to specify \link{breakpoints}.
}}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \code{item_align()} function adjusts
}
\examples{

library(htmltools)

div(
  .style \%>\%
    flex_display() \%>\%
    flex_align("end"),
  div("Flex item"),
  div(
    .style \%>\%
      item_align("start"),
    "Flex item (self aligned)"
  ),
  div("Flex item")
)

}
\seealso{
Other flex utilities: 
\code{\link{flex_align}()},
\code{\link{flex_content}()},
\code{\link{flex_direction}()},
\code{\link{flex_display}()},
\code{\link{flex_justify}()},
\code{\link{flex_wrap}()},
\code{\link{item_fill}()},
\code{\link{item_grow}()},
\code{\link{item_order}()}
}
\concept{flex utilities}
