% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/margin-all.R
\name{margin_all}
\alias{margin_all}
\alias{margin_top}
\alias{margin_right}
\alias{margin_bottom}
\alias{margin_left}
\alias{margin_horizontal}
\alias{margin_vertical}
\title{Margins}
\usage{
margin_all(x, ...)

margin_top(x, ...)

margin_right(x, ...)

margin_bottom(x, ...)

margin_left(x, ...)

margin_horizontal(x, ...)

margin_vertical(x, ...)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{...}{A number or character string specifying a margin. One or more of,
\itemize{
\item \code{"-5"}
\item \code{"-4"}
\item \code{"-3"}
\item \code{"-2"}
\item \code{"-1"}
\item \code{0}
\item \code{1}
\item \code{2}
\item \code{3}
\item \code{4}
\item \code{5}
\item \code{"auto"}

Use name-value pairs to specify \link{breakpoints}.
}}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \verb{margin_*()} functions adjust a tag element's margin, the space outside
and around the element, its border, and its content.
}
\examples{

library(htmltools)

div(
  .style \%>\%
    margin_left(3) \%>\%
    margin_right(3),
  "Left margin, right margin"
)

div(
  .style \%>\%
    margin_horizontal(3),
  "Shorthand for left and right margins"
)

div(
  .style \%>\%
    margin_horizontal("auto"),
  "A centered element."
)

}
\seealso{
\code{\link[=gap_all]{gap_all()}} for flex spacing.
}
