% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text-size.R
\name{text_size}
\alias{text_size}
\title{Text size}
\usage{
text_size(x, size)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{size}{A number specifying a font size for the text. One of,
\itemize{
\item \code{1}
\item \code{2}
\item \code{3}
\item \code{4}
\item \code{5}
\item \code{6}

The sizes follow the conventions of HTML heading tags, so \code{1} is the largest
font and \code{6} the smallest.
}}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \code{text_size()} function adjusts the font size of a tag element.
}
\examples{

library(htmltools)

p(
  .style \%>\%
    text_size(1),
  "Largest size"
)

p(
  .style \%>\%
    text_size(6),
  "Smallest size"
)

}
