% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Common.R
\name{dtgamma}
\alias{dtgamma}
\alias{ptgamma}
\alias{qtgamma}
\alias{rtgamma}
\title{Density function of Truncated Gamma Distribution}
\usage{
dtgamma(x, shape, scale, min = 0, max = 1e+09)

ptgamma(q, shape, scale, min = 0, max = 1e+09)

qtgamma(p, shape, scale, min = 0, max = 1e+09)

rtgamma(n, shape, scale, min = 0, max = 1e+09)
}
\arguments{
\item{x}{Value of the variable after deductible and limit max(0,min(claim,limit)-deductible)}

\item{shape}{Shape parameter}

\item{scale}{Scale parameter}

\item{min}{Left truncation deductible}

\item{max}{Right truncation limit}

\item{q}{Value of the variable after deductible and limit max(0,min(claim,limit)-deductible)}

\item{p}{Value of the probability}

\item{n}{Number of samples}
}
\description{
Density function of Truncated Gamma Distribution

Cumulative probability function of Truncated Gamma Distribution

Quantile function of Truncated Gamma Distribution max(0,min(claim,limit)-deductible)

Random generation of Truncated Gamma Distribution max(0,min(claim,limit)-deductible)
}
\examples{
dtgamma(2,3,2)
ptgamma(2,3,2)
qtgamma(0.5,3,2)
rtgamma(100,3,2)
}
