% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{nfa_cat}
\alias{nfa_cat}
\title{Need for Affect Cat Object}
\format{
An object of class \code{Cat} of length 1.
}
\source{
See \code{https://dataverse.harvard.edu/dataverse/pdsl} for the raw YouGov and/or Qualtrics data.

See \url{https://wc.wustl.edu} for raw TAPS data.
}
\usage{
data(nfa_cat)
}
\description{
Cat object containing item parameters for graded response model fit with responses to the 26 item Need for Affect inventory
}
\details{
Cat object containing item parameters for graded response model fit with 2507 response profiles from MTurk,
4990 response profiles collected by Qualtrics in June 2018,
and 1512 response profiles from The American Panel Survey (TAPS) in December 2014.
TAPS is a monthly online panel survey  of about 2,000 adults in the United States. The panel was recruited in 
the fall of 2011 using an address-based sampling frame.  TAPS surveys are administered online.  
Selected panelists who do not have a computer or online service are provided a computer and internet access by TAPS. 


See \code{\link{Cat-class}} for details regarding the Cat object structure.
See \code{\link{grmCat}} for details regarding the graded response model.

A normal prior was chosen with mean from the theta estimates from the TAPS sample (.236) and a standard deviation (1.3)
wide enough to envelope the range of estimated theta values across both samples.

Note that due to how the item parameters were estimated, large, positive values indicate "more" of the latent trait.

Response options are:

5 = Strongly agree, 4 = Somewhat agree, 3 = Neither agree nor disagree, 2 = Somewhat disagree, 1 = Strongly disagree

The wording of the question items is: 

\describe{
\item{\code{q1}}{It is important for me to be in touch with my feelings.}
\item{\code{q2}}{I think that it is very important to explore my feelings.} 
\item{\code{q3}}{I am a very emotional person.} 
\item{\code{q4}}{It is important for me to know how others are feeling.} 
\item{\code{q5}}{Emotions help people get along in life.}
\item{\code{q6}}{Strong emotions are generally beneficial.} 
\item{\code{q7}}{I feel that I need to experience strong emotions regularly.}
\item{\code{q8}}{I approach situations in which I expect to experience strong emotions.} 
\item{\code{q9}}{I feel like I need a good cry every now and then.} 
\item{\code{q10}}{I like to dwell on my emotions.} 
\item{\code{q11}}{We should indulge our emotions.}
\item{\code{q12}}{I like decorating my bedroom with a lot of pictures and posters of things emotionally significant to me.} 
\item{\code{q13}}{The experience of emotions promotes human survival.} 
\item{\code{q14}}{I do not know how to handle my emotion, so I avoid them.} 
\item{\code{q15}}{I find strong emotions overwhelming and therefore try to avoid them.} 
\item{\code{q16}}{Emotions are dangerous---they tend to get me into situations that I would rather avoid.} 
\item{\code{q17}}{I would prefer not to experience either the lows or highs of emotion.}
\item{\code{q18}}{If I reflect on my past, I see that I tend to be afraid of emotions.} 
\item{\code{q19}}{I would love to be like Mr. Spock, who is totally logical and experiences little emotion.} 
\item{\code{q20}}{I have trouble telling the people close to me that I love them.} 
\item{\code{q21}}{Displays of emotions are embarrassing.} 
\item{\code{q22}}{Acting on ones emotions is always a mistake.} 
\item{\code{q23}}{I am sometimes afraid of how I might act if I become too emotional.} 
\item{\code{q24}}{Avoiding emotional events helps me sleep better at night.} 
\item{\code{q25}}{I wish I could feel less emotion.}
\item{\code{q26}}{People can function most effectively when they are not experiencing strong emotions.} 
}
}
\references{
Maio, Gregory R., and Victoria M. Esses. "The need for affect: Individual
 differences in the motivation to approach or avoid emotions." 
 Journal of personality 69.4 (2001): 583-614.
}
\seealso{
\code{\link{Cat-class}}, \code{\link{grmCat}}
}
\keyword{datasets}
