% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{cache_table}
\alias{cache_table}
\alias{clear_cache}
\alias{is_cached}
\alias{uncache_table}
\title{Cache And Uncache Tables}
\usage{
cache_table(sc, table)

clear_cache(sc)

is_cached(sc, table)

uncache_table(sc, table)
}
\arguments{
\item{sc}{A \code{spark_connection}.}

\item{table}{\code{character(1)}. The name of the table.}
}
\value{
\itemize{
\item \code{cache_table()}: If successful, \code{TRUE}, otherwise \code{FALSE}.
}

\itemize{
\item \code{clear_cache()}: \code{NULL}, invisibly.
}

\itemize{
\item \code{is_cached()}: A \code{logical(1)} vector indicating \code{TRUE} if the table is
cached and \code{FALSE} otherwise.
}

\itemize{
\item \code{uncache_table()}: \code{NULL}, invisibly.
}
}
\description{
Spark SQL can cache tables using an in-memory columnar format by calling
\code{cache_table()}. Spark SQL will scan only required columns and will
automatically tune compression to minimize memory usage and GC pressure.
You can call \code{uncache_table()} to remove the table from memory. Similarly you
can call \code{clear_cache()} to remove all cached tables from the in-memory
cache. Finally, use \code{is_cached()} to test whether or not a table is cached.
}
\examples{
\dontrun{
sc <- sparklyr::spark_connect(master = "local")
mtcars_spark <- sparklyr::copy_to(dest = sc, df = mtcars)

# By default the table is not cached
is_cached(sc = sc, table = "mtcars")

# We can manually cache the table
cache_table(sc = sc, table = "mtcars")
# And now the table is cached
is_cached(sc = sc, table = "mtcars")

# We can uncache the table
uncache_table(sc = sc, table = "mtcars")
is_cached(sc = sc, table = "mtcars")
}

}
\seealso{
\code{\link[=create_table]{create_table()}}, \code{\link[=get_table]{get_table()}}, \code{\link[=list_tables]{list_tables()}}, \code{\link[=refresh_table]{refresh_table()}},
\code{\link[=table_exists]{table_exists()}}, \code{\link[=uncache_table]{uncache_table()}}
}
