% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat_glm_tune.R
\name{mallowian_estimate}
\alias{mallowian_estimate}
\title{Perform Mallowian Estimate for Model Risk (Only Applicable for Gaussian Family)}
\usage{
mallowian_estimate(formula, cat_init, tau_seq, ...)
}
\arguments{
\item{formula}{A formula specifying the GLMs. Should at least include response variables.}

\item{cat_init}{A list generated from \code{cat_glm_initialization}.}

\item{tau_seq}{A sequence of tuning parameter values (\code{tau}) over which
the Mallowian estimate will be computed. Each value of \code{tau} is used to weight the
synthetic data during model fitting.}

\item{...}{Other arguments passed to other internal functions.}
}
\value{
A numeric vector of Mallowian risk estimates, one for each value of \code{tau} in \code{tau_seq}.
}
\description{
This function calculates the Mallowian estimate for model risk by fitting a sequence of
Generalized Linear Models (GLMs) with varying values of \code{tau}. It uses the in-sample prediction
error along with a regularized projection matrix to estimate the model risk. The \code{tau} parameter
influences the weighting of synthetic data during model fitting.
}
\details{
\enumerate{
\item \strong{Model Fitting}: For each value of \code{tau} in \code{tau_seq}, the function fits a GLM model
using the observed and synthetic data. The synthetic data is weighted by the corresponding
\code{tau} value during the fitting process.
\item \strong{In-sample Prediction Error}: After fitting the model, the function computes the
in-sample prediction error (Mean Squared Error) to assess the model's performance.
\item \strong{Regularized Projection Matrix}: The function calculates a regularized projection matrix
using the observed and synthetic data, which influences the covariance matrix used in risk estimation.
\item \strong{Mallowian Risk Estimate}: The final Mallowian risk estimate is computed by combining the
in-sample prediction error with a penalty term involving the projection matrix and a variance term.
This estimate is calculated for each value of \code{tau} in \code{tau_seq}.
}
}
